/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.client.Client2ControlTransport;
import com.ovopark.iohub.sdk.client.Client2WorkRestClient;
import com.ovopark.iohub.sdk.client.Client2WorkTransport;
import com.ovopark.iohub.sdk.client.ClientNode;
import com.ovopark.iohub.sdk.client.ClientNodeRegister;
import com.ovopark.iohub.sdk.client.IOHubClientConfig;
import com.ovopark.iohub.sdk.client.JobClientActive;
import com.ovopark.iohub.sdk.client.JobLogImpl;
import com.ovopark.iohub.sdk.client.outstream.HttpWriter;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlowProvider;
import com.ovopark.iohub.sdk.client.outstream.RequestParamBody;
import com.ovopark.iohub.sdk.model.AppNode;
import com.ovopark.iohub.sdk.model.ClientNodeTaskRegisterRequest;
import com.ovopark.iohub.sdk.model.ClientNodeTaskRegisterResponse;
import com.ovopark.iohub.sdk.model.CreateExportRecordRequest;
import com.ovopark.iohub.sdk.model.CreateExportRecordResponse;
import com.ovopark.iohub.sdk.model.JobMeta;
import com.ovopark.iohub.sdk.model.TaskLockRequest;
import com.ovopark.iohub.sdk.model.TaskLockResponse;
import com.ovopark.iohub.sdk.model.TaskModel;
import com.ovopark.iohub.sdk.model.TaskSubmitRequest;
import com.ovopark.iohub.sdk.model.TaskSubmitResponse;
import com.ovopark.iohub.sdk.model.outstream.ExportPushStartRequest;
import com.ovopark.iohub.sdk.model.outstream.ExportPushStartResponse;
import com.ovopark.iohub.sdk.model.proto.InMemoryOutStore;
import com.ovopark.iohub.sdk.model.proto.NFSOutStore;
import com.ovopark.iohub.sdk.model.proto.NoPrivilegeException;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.kernel.shared.CachedExecutors;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.CacheService;
import com.ovopark.module.shared.Session;
import com.ovopark.module.shared.spring.rbac.SessionImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@JobClientActive
@RestController(value="com.ovopark.iohub.sdk.client.outstream.ExportEndpoint")
@RequestMapping(value={"/feign/iohub-job/processing"})
public class ExportEndpoint
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ExportEndpoint.class);
    @Autowired
    private Client2ControlTransport jobClient2ControlTransport;
    private static final ExecutorService jobExecutor = new ThreadPoolExecutor(Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 64), Integer.parseInt(System.getProperty("MESSAGEHUB_JOB_IO", "0"))), Math.max(Math.max(Runtime.getRuntime().availableProcessors() * 2, 1024), Integer.parseInt(System.getProperty("MESSAGEHUB_JOB_IO", "0"))), 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), Util.newThreadFactory((String)"messagehub-job-io"), new ThreadPoolExecutor.AbortPolicy());
    private static final CacheService<String, TaskSubmitRequest> C = new CacheService.MapCacheService(true, CachedExecutors.impl((String)"messagehub-job-io-c", (int)1, (int)1));
    private final Set<Long> executingJobTaskIdSet = ConcurrentHashMap.newKeySet();
    final Map<String, SubmitTask> submitTaskMap = new ConcurrentHashMap<String, SubmitTask>();
    @Autowired
    private IOHubClientConfig ioHubClientConfig;
    @Autowired
    private JobOutTaskFlowProvider jobOutTaskFlowProvider;
    @Autowired
    private ClientNodeRegister.ClientNodeProvider clientNodeProvider;
    private static JobTaskManager instance;
    private final SimpleJobTaskManager simpleJobTaskManager = new SimpleJobTaskManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/submit"})
    @ResponseBody
    public TaskSubmitResponse submit(final @RequestBody TaskSubmitRequest taskSubmitRequest) {
        final String taskKey = "task_" + taskSubmitRequest.getTaskId();
        MDC.put((String)"traceId", (String)taskKey);
        MDC.put((String)"requestId", (String)taskKey);
        log.info("receive a new task, we can do it???: " + JSONAccessor.impl().format((Object)taskSubmitRequest));
        final TaskSubmitResponse taskSubmitResponse = new TaskSubmitResponse();
        taskSubmitResponse.setSubmitted(false);
        final JobLogImpl jobLog = new JobLogImpl(this.jobClient2ControlTransport, 300, taskKey);
        try {
            Util.lock((Comparable)((Object)taskKey), (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    C.putIfAbsentAndGet((Comparable)((Object)taskKey), (Supplier)new Supplier<TaskSubmitRequest>(){

                        @Override
                        public TaskSubmitRequest get() {
                            if (ExportEndpoint.this.executingJobTaskIdSet.contains(taskSubmitRequest.getTaskId())) {
                                taskSubmitResponse.setSubmitted(false);
                                taskSubmitResponse.setDesc("Rejected,the previous task is executing");
                                throw new IllegalStateException("the previous task is executing, reject the task: " + JSONAccessor.impl().format((Object)taskSubmitRequest));
                            }
                            TaskLockRequest taskLockRequest = new TaskLockRequest();
                            taskLockRequest.setTaskId(taskSubmitRequest.getTaskId());
                            taskLockRequest.setNode(ClientNode.UUID_STR);
                            TaskLockResponse taskLockResponse = ExportEndpoint.this.jobClient2ControlTransport.lockClient(taskLockRequest);
                            if (taskLockResponse == null || !taskLockResponse.isSuccess()) {
                                throw new IllegalStateException("cannot get lock: " + JSONAccessor.impl().format((Object)taskLockRequest));
                            }
                            ExportEndpoint.this.executingJobTaskIdSet.add(taskSubmitRequest.getTaskId());
                            long taskId = taskSubmitRequest.getTaskId();
                            String uri = taskSubmitRequest.getUri();
                            String args = taskSubmitRequest.getArgs();
                            String session = taskSubmitRequest.getSession();
                            boolean retry = taskSubmitRequest.isRetry();
                            Integer exportTaskId = taskSubmitRequest.getExportTaskId();
                            JobMeta jobMeta = taskSubmitRequest.getJobMeta();
                            AppNode worker = taskSubmitRequest.getWorker();
                            JobTaskManager jobTaskManager = new JobTaskManager(){

                                @Override
                                public void cancel(long taskId) {
                                    SubmitTask submitTask = ExportEndpoint.this.submitTaskMap.get("task_" + taskId);
                                    submitTask.future.cancel(true);
                                    log.info("cancel the task");
                                    jobLog.log("cancel the task");
                                }
                            };
                            ClientNode clientNode = ExportEndpoint.this.clientNodeProvider.clientNode();
                            SessionImpl si = Util.isEmpty((CharSequence)session) ? null : (SessionImpl)JSONAccessor.impl().read(session, SessionImpl.class);
                            SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
                            factory.setReadTimeout(45000);
                            factory.setConnectTimeout(15000);
                            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
                            Client2WorkRestClient client2WorkTransport = new Client2WorkRestClient(worker, restTemplate);
                            ExportPushStartRequest exportPushStartRequest = new ExportPushStartRequest();
                            exportPushStartRequest.setTaskId(taskId);
                            exportPushStartRequest.setApp(clientNode.app());
                            exportPushStartRequest.setClientNode(clientNode.node());
                            exportPushStartRequest.setWorkApp(worker.getApp());
                            exportPushStartRequest.setWorkNode(worker.getNode());
                            exportPushStartRequest.setExportTaskId(exportTaskId);
                            log.info("to request resource : ");
                            jobLog.log("to request resource : ");
                            ExportPushStartResponse exportPushStartResponse = client2WorkTransport.start(exportPushStartRequest);
                            if (exportPushStartResponse == null || !exportPushStartResponse.isSuccess()) {
                                jobLog.log("cannot get enough resource , break the export task.");
                                log.info("cannot get enough resource , break the export task.");
                                taskSubmitResponse.setSubmitted(false);
                                taskSubmitResponse.setDesc("resource limit");
                                throw new IllegalStateException("resource limit, reject the task: " + JSONAccessor.impl().format((Object)taskSubmitRequest));
                            }
                            log.info("get request resource : ");
                            jobLog.log("get request resource : ");
                            JobOutTaskFlow<RequestParamBody> jobOutTaskFlow = ExportEndpoint.this.jobOutTaskFlowProvider.find(uri);
                            try {
                                jobOutTaskFlow.prepared();
                                log.info("prepare bean : ");
                                jobLog.log("prepare bean : ");
                                RequestParamBody requestParamBody = null;
                                if (retry) {
                                    requestParamBody = (RequestParamBody)JSONAccessor.impl().read(args, jobOutTaskFlow.paramType());
                                } else {
                                    try {
                                        requestParamBody = jobOutTaskFlow.requestParamBody(args, (Session)si);
                                    }
                                    catch (NoPrivilegeException e) {
                                        taskSubmitResponse.setSubmitted(false);
                                        taskSubmitResponse.setDesc("no privilege");
                                        throw new IllegalStateException("no privilege, reject the task: " + JSONAccessor.impl().format((Object)taskSubmitRequest));
                                    }
                                    catch (Exception e) {
                                        taskSubmitResponse.setSubmitted(false);
                                        taskSubmitResponse.setDesc(e.getMessage());
                                        log.error(e.getMessage(), (Throwable)e);
                                        throw new IllegalStateException("error, reject the task: " + e.getMessage() + JSONAccessor.impl().format((Object)taskSubmitRequest));
                                    }
                                    JobOutTaskFlow.ExportTaskInfoProvider exportTaskInfoProvider = jobOutTaskFlow.exportTaskInfoProvider(requestParamBody, (Session)si);
                                    CreateExportRecordRequest createExportRecordRequest = new CreateExportRecordRequest();
                                    createExportRecordRequest.setRequestParamBody((Object)requestParamBody);
                                    createExportRecordRequest.setExportTaskName(exportTaskInfoProvider == null ? null : exportTaskInfoProvider.name());
                                    createExportRecordRequest.setTaskId(taskId);
                                    createExportRecordRequest.setApp(clientNode.app());
                                    createExportRecordRequest.setNode(clientNode.node());
                                    createExportRecordRequest.setWorkApp(worker.getApp());
                                    createExportRecordRequest.setWorkNode(worker.getNode());
                                    createExportRecordRequest.setUserId(si == null ? null : si.getUserId());
                                    createExportRecordRequest.setGroupId(si == null ? null : si.getGroupId());
                                    createExportRecordRequest.setJobMeta(jobMeta);
                                    CreateExportRecordResponse exportRecord = client2WorkTransport.createExportRecord(createExportRecordRequest);
                                    jobLog.log("createExportRecord: " + JSONAccessor.impl().format((Object)exportRecord));
                                    if (exportRecord == null || !exportRecord.isSuccess() || exportRecord.getExportTaskId() == null) {
                                        jobLog.log("cannot get exportRecord id , break the export task.");
                                        log.info("cannot get exportRecord id , break the export task.");
                                        taskSubmitResponse.setSubmitted(false);
                                        taskSubmitResponse.setDesc("cannot create exportRecord");
                                        throw new IllegalStateException("cannot create exportRecord: " + JSONAccessor.impl().format((Object)taskSubmitRequest));
                                    }
                                    log.info("created export record  , export record id: " + exportRecord.getExportTaskId());
                                    jobLog.log("created export record , export record id: " + exportRecord.getExportTaskId());
                                    taskSubmitResponse.setExportTaskId(exportRecord.getExportTaskId());
                                }
                                Object outStore = jobMeta.isNfs() ? new NFSOutStore(ExportEndpoint.this.ioHubClientConfig.nfsPath() + "/client-" + ClientNode.UUID_STR, 1) : new InMemoryOutStore(Math.min(jobMeta.getSegmentCount(), 10));
                                log.info("create out store , nfs ? : " + jobMeta.isNfs());
                                jobLog.log("create out store , nfs ? : " + jobMeta.isNfs());
                                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, Util.newThreadFactory((String)"tmp"), new ThreadPoolExecutor.CallerRunsPolicy());
                                scheduledThreadPoolExecutor.setKeepAliveTime(60L, TimeUnit.SECONDS);
                                scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
                                ClientNodeTaskRegisterRequest clientNodeTaskRegisterRequest = new ClientNodeTaskRegisterRequest();
                                clientNodeTaskRegisterRequest.setTaskId(taskId);
                                clientNodeTaskRegisterRequest.setApp(clientNode.app());
                                clientNodeTaskRegisterRequest.setNode(clientNode.node());
                                clientNodeTaskRegisterRequest.setWorkApp(worker.getApp());
                                clientNodeTaskRegisterRequest.setWorkNode(worker.getNode());
                                RequestParamBody finalRequestParamBody = requestParamBody;
                                try {
                                    Future<?> future = jobExecutor.submit(Util.catchRunnable(() -> this.lambda$get$0(taskKey, jobOutTaskFlow, finalRequestParamBody, (OutStore)outStore, client2WorkTransport, taskId, clientNode, worker, clientNodeTaskRegisterRequest, scheduledThreadPoolExecutor, jobMeta, jobTaskManager, taskLockRequest)));
                                    SubmitTask submitTask = new SubmitTask();
                                    submitTask.setTaskId(taskSubmitRequest.getTaskId());
                                    submitTask.setFuture(future);
                                    submitTask.setTaskModel(new TaskModel());
                                    submitTask.getTaskModel().setJobTaskId(taskSubmitRequest.getTaskId());
                                    submitTask.getTaskModel().setExportTaskId(taskSubmitRequest.getExportTaskId());
                                    submitTask.getTaskModel().setWorkNode(taskSubmitRequest.getWorker().getNode());
                                    submitTask.getTaskModel().setClientNode(ClientNode.UUID_STR);
                                    submitTask.getTaskModel().setAcceptTime(System.currentTimeMillis());
                                    submitTask.getTaskModel().setAcceptTimeStr(Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]));
                                    ExportEndpoint.this.submitTaskMap.put(taskKey, submitTask);
                                    log.info("OK, the task is scheduled: " + taskKey);
                                    taskSubmitResponse.setSubmitted(true);
                                }
                                catch (RejectedExecutionException e) {
                                    ExportEndpoint.this.executingJobTaskIdSet.remove(taskLockRequest.getTaskId());
                                    taskSubmitResponse.setSubmitted(false);
                                    taskSubmitResponse.setDesc("Rejected, resource is unavailable ");
                                    throw Util.convert2RuntimeException((Throwable)e);
                                }
                            }
                            catch (Exception e) {
                                jobLog.log("error : " + e.getMessage());
                                throw Util.convert2RuntimeException((Throwable)e);
                            }
                            finally {
                                jobOutTaskFlow.close();
                                jobLog.close();
                            }
                            return taskSubmitRequest;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private /* synthetic */ void lambda$get$0(String taskKey, final JobOutTaskFlow jobOutTaskFlow, final RequestParamBody finalRequestParamBody, final OutStore outStore, final Client2WorkTransport client2WorkTransport, final long taskId, final ClientNode clientNode, final AppNode worker, ClientNodeTaskRegisterRequest clientNodeTaskRegisterRequest, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, JobMeta jobMeta, JobTaskManager jobTaskManager, TaskLockRequest taskLockRequest) throws Exception {
                            final JobLogImpl jobLog = new JobLogImpl(ExportEndpoint.this.jobClient2ControlTransport, 300, taskKey);
                            try {
                                ExportEndpoint.this.doTask(new Callable<Void>(){

                                    @Override
                                    public Void call() throws Exception {
                                        log.info("to get all data ");
                                        jobLog.log("to get all data ");
                                        jobLog.flush();
                                        try {
                                            jobOutTaskFlow.execute(finalRequestParamBody, outStore);
                                            outStore.commit();
                                        }
                                        catch (Exception e) {
                                            jobLog.log("job out task flow error: " + e.getMessage());
                                            throw Util.convert2RuntimeException((Throwable)e);
                                        }
                                        finally {
                                            outStore.close();
                                        }
                                        log.info("got all data , then push meta to work");
                                        jobLog.log("got all data , then push meta to work");
                                        jobLog.flush();
                                        HttpWriter httpWriter = new HttpWriter(client2WorkTransport);
                                        httpWriter.writeAndCommit(outStore.sdList(), outStore, taskId, clientNode, worker);
                                        log.info("task completed, and all data pushed to worker, wait worker generate xlsx???");
                                        jobLog.log("task completed, and all data pushed to worker, wait worker generate xlsx???");
                                        return null;
                                    }
                                }, client2WorkTransport, clientNodeTaskRegisterRequest, scheduledThreadPoolExecutor, taskId, jobMeta, jobTaskManager);
                            }
                            finally {
                                try {
                                    ExportEndpoint.this.submitTaskMap.remove(taskKey);
                                }
                                catch (Exception e) {
                                    log.error(e.getMessage(), (Throwable)e);
                                }
                                ExportEndpoint.this.executingJobTaskIdSet.remove(taskLockRequest.getTaskId());
                                try {
                                    jobLog.log(taskKey + " > completed: " + Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]));
                                    jobLog.flush();
                                    jobLog.close();
                                }
                                catch (Exception e) {
                                    log.error(e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                    }, 60L, TimeUnit.SECONDS);
                    return null;
                }
            }, (long)10L, (TimeUnit)TimeUnit.SECONDS);
            return taskSubmitResponse;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return taskSubmitResponse;
        }
        finally {
            try {
                jobLog.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                MDC.remove((String)"traceId");
                MDC.remove((String)"requestId");
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        instance = this.simpleJobTaskManager;
    }

    private <T> T doTask(Callable<T> callable, final Client2WorkTransport client2WorkTransport, final ClientNodeTaskRegisterRequest clientNodeTaskRegisterRequest, ScheduledExecutorService taskHeartbeat, final long taskId, JobMeta jobMeta, final JobTaskManager jobTaskManager) {
        ScheduledFuture<?> scheduledFuture = taskHeartbeat.scheduleWithFixedDelay(Util.catchRunnable((Util.CatchRunnable)new Util.CatchRunnable(){
            int failCount = 0;

            public void run() throws Exception {
                ClientNodeTaskRegisterResponse clientNodeTaskRegisterResponse = client2WorkTransport.exportHeartbeat(clientNodeTaskRegisterRequest);
                log.info("heartbeat from work(" + clientNodeTaskRegisterRequest.getWorkApp() + ":" + clientNodeTaskRegisterRequest.getWorkNode() + ") : " + JSONAccessor.impl().format((Object)clientNodeTaskRegisterResponse));
                if (clientNodeTaskRegisterResponse == null || !clientNodeTaskRegisterResponse.isSuccess()) {
                    ++this.failCount;
                    if (this.failCount > 3) {
                        jobTaskManager.cancel(taskId);
                    }
                    return;
                }
                this.failCount = 0;
            }
        }), 0L, 5L, TimeUnit.SECONDS);
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw Util.convert2RuntimeException((Throwable)e);
        }
        finally {
            scheduledFuture.cancel(true);
            log.info("cancel heartbeat thread");
        }
    }

    public static interface JobTaskManager {
        public void cancel(long var1);

        default public List<TaskModel> taskList() {
            throw new UnsupportedOperationException();
        }

        public static JobTaskManager getOrCreate() {
            return instance;
        }
    }

    private class SimpleJobTaskManager
    implements JobTaskManager {
        private SimpleJobTaskManager() {
        }

        @Override
        public void cancel(long taskId) {
            SubmitTask submitTask = ExportEndpoint.this.submitTaskMap.get("task_" + taskId);
            if (submitTask == null) {
                return;
            }
            if (submitTask.future == null) {
                return;
            }
            submitTask.future.cancel(true);
            log.info("cancel the task");
        }

        @Override
        public List<TaskModel> taskList() {
            ArrayList<TaskModel> taskModelList = new ArrayList<TaskModel>(ExportEndpoint.this.submitTaskMap.size());
            for (SubmitTask submitTask : ExportEndpoint.this.submitTaskMap.values()) {
                taskModelList.add(submitTask.getTaskModel());
            }
            return taskModelList;
        }
    }

    public static class SubmitTask {
        private long taskId;
        private Future<?> future;
        private TaskModel taskModel;

        public long getTaskId() {
            return this.taskId;
        }

        public Future<?> getFuture() {
            return this.future;
        }

        public TaskModel getTaskModel() {
            return this.taskModel;
        }

        public void setTaskId(long taskId) {
            this.taskId = taskId;
        }

        public void setFuture(Future<?> future) {
            this.future = future;
        }

        public void setTaskModel(TaskModel taskModel) {
            this.taskModel = taskModel;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubmitTask)) {
                return false;
            }
            SubmitTask other = (SubmitTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTaskId() != other.getTaskId()) {
                return false;
            }
            Future<?> this$future = this.getFuture();
            Future<?> other$future = other.getFuture();
            if (this$future == null ? other$future != null : !this$future.equals(other$future)) {
                return false;
            }
            TaskModel this$taskModel = this.getTaskModel();
            TaskModel other$taskModel = other.getTaskModel();
            return !(this$taskModel == null ? other$taskModel != null : !this$taskModel.equals(other$taskModel));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SubmitTask;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $taskId = this.getTaskId();
            result = result * 59 + (int)($taskId >>> 32 ^ $taskId);
            Future<?> $future = this.getFuture();
            result = result * 59 + ($future == null ? 43 : $future.hashCode());
            TaskModel $taskModel = this.getTaskModel();
            result = result * 59 + ($taskModel == null ? 43 : $taskModel.hashCode());
            return result;
        }

        public String toString() {
            return "ExportEndpoint.SubmitTask(taskId=" + this.getTaskId() + ", future=" + this.getFuture() + ", taskModel=" + this.getTaskModel() + ")";
        }
    }
}

