/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.client.Client2ControlTransport;
import com.ovopark.iohub.sdk.client.ControlNodeProxy;
import com.ovopark.iohub.sdk.client.JobClientActive;
import com.ovopark.iohub.sdk.model.ClientNodeRegisterRequest;
import com.ovopark.iohub.sdk.model.ClientNodeRegisterResponse;
import com.ovopark.iohub.sdk.model.PreFlowErrorRequest;
import com.ovopark.iohub.sdk.model.PreFlowErrorResponse;
import com.ovopark.iohub.sdk.model.TaskLockRequest;
import com.ovopark.iohub.sdk.model.TaskLockResponse;
import com.ovopark.iohub.sdk.model.TaskLogRequest;
import com.ovopark.iohub.sdk.model.TaskLogResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@JobClientActive
@Component
public class Client2ControlRestClient
implements Client2ControlTransport {
    private static final Logger log = LoggerFactory.getLogger(Client2ControlRestClient.class);
    private final RestTemplate restTemplate;
    @Autowired
    private ControlNodeProxy appNode;

    public Client2ControlRestClient() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(45000);
        factory.setConnectTimeout(15000);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Override
    public ClientNodeRegisterResponse heartbeat(ClientNodeRegisterRequest clientNodeRegisterRequest) {
        return this.rpc(clientNodeRegisterRequest, "/jobClient/heartbeat", ClientNodeRegisterResponse.class);
    }

    private <T> T rpc(Object request, String path, Class<T> clazz) {
        String url = "http://" + this.appNode.ip() + ":" + this.appNode.port() + "/iohub-control";
        url = url + path;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity formEntity = new HttpEntity((Object)JSONAccessor.impl().format(request), (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)formEntity, String.class, new Object[0]);
            int statusCodeValue = responseEntity.getStatusCodeValue();
            if (statusCodeValue == 200) {
                return (T)JSONAccessor.impl().read((String)responseEntity.getBody(), clazz);
            }
            return null;
        }
        catch (RestClientException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private <T> T restWithFile(Map<String, Object> params, String file, String path, Class<T> clazz) {
        String url = "http://" + this.appNode.ip() + ":" + this.appNode.port() + "/iohub-control";
        url = url + path;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "multipart/form-data");
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            multiValueMap.add((Object)entry.getKey(), entry.getValue());
        }
        multiValueMap.add((Object)"file", (Object)new FileSystemResource(file));
        HttpEntity formEntity = new HttpEntity((Object)multiValueMap, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)formEntity, String.class, new Object[0]);
            int statusCodeValue = responseEntity.getStatusCodeValue();
            if (statusCodeValue == 200) {
                return (T)JSONAccessor.impl().read((String)responseEntity.getBody(), clazz);
            }
            return null;
        }
        catch (RestClientException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    @Override
    public TaskLockResponse lockClient(TaskLockRequest taskLockRequest) {
        return this.rpc(taskLockRequest, "/jobClient/lockClient", TaskLockResponse.class);
    }

    @Override
    public TaskLogResponse log(TaskLogRequest taskLogRequest) {
        return this.rpc(taskLogRequest, "/jobClient/log", TaskLogResponse.class);
    }

    @Override
    public PreFlowErrorResponse preFlowError(PreFlowErrorRequest preFlowErrorRequest) {
        return this.rpc(preFlowErrorRequest, "/jobClient/preFlowError", PreFlowErrorResponse.class);
    }
}

