/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.client.ClientNode;
import com.ovopark.iohub.sdk.client.ControlNode;
import com.ovopark.iohub.sdk.model.ClientConfigRequest;
import com.ovopark.iohub.sdk.model.ClientConfigResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class NacosControlNode
implements ControlNode,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(NacosControlNode.class);
    @Autowired
    private ServiceInstance serviceInstance;
    @Autowired
    private DiscoveryClient discoveryClient;
    @Value(value="${spring.application.name}")
    private String app;
    static final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    private static final String PATH = "/iohub-control/jobClient/control-config";
    private String ip = "127.0.0.1";
    private int port = 13910;

    public void afterPropertiesSet() throws Exception {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(45000);
        factory.setConnectTimeout(15000);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        ClientConfigRequest clientConfigRequest = new ClientConfigRequest();
        clientConfigRequest.setApp(this.app);
        clientConfigRequest.setNode(ClientNode.UUID_STR);
        Util.schedule((ScheduledExecutorService)scheduledExecutorService, () -> {
            ArrayList serviceInstanceList = new ArrayList(this.discoveryClient.getInstances("iohub-control"));
            if (Util.isEmpty(serviceInstanceList)) {
                return;
            }
            ServiceInstance instance = (ServiceInstance)serviceInstanceList.get(0);
            URI instanceUri = instance.getUri();
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", "application/json");
            HttpEntity formEntity = new HttpEntity((Object)JSONAccessor.impl().format((Object)clientConfigRequest), (MultiValueMap)headers);
            try {
                ResponseEntity responseEntity = restTemplate.postForEntity(instanceUri + PATH, (Object)formEntity, String.class, new Object[0]);
                int statusCodeValue = responseEntity.getStatusCodeValue();
                if (statusCodeValue == 200) {
                    ClientConfigResponse clientConfigResponse = (ClientConfigResponse)JSONAccessor.impl().read((String)responseEntity.getBody(), ClientConfigResponse.class);
                    if (Util.isNotEmpty((CharSequence)clientConfigResponse.getControlIp())) {
                        this.ip = clientConfigResponse.getControlIp();
                    }
                    if (clientConfigResponse.getControlPort() > 0) {
                        this.port = clientConfigResponse.getControlPort();
                    }
                }
            }
            catch (RestClientException e) {
                log.debug(e.getMessage());
            }
        }, (long)5L, (TimeUnit)TimeUnit.SECONDS, e -> true, () -> true);
    }

    @Override
    public String ip() {
        return this.ip;
    }

    @Override
    public int port() {
        return this.port;
    }
}

