/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client.instream;

import com.ovopark.iohub.sdk.client.outstream.RequestParamBody;
import com.ovopark.iohub.sdk.model.proto.ImportPreDefConf;
import com.ovopark.iohub.sdk.model.proto.NoPrivilegeException;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.Model;
import com.ovopark.module.shared.Session;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

public interface JobInTaskFlow<T extends RequestParamBody> {
    default public void prepared() {
    }

    public T requestParamBody(String var1, Session var2) throws NoPrivilegeException;

    default public ImportTaskInfoProvider importTaskInfoProvider(T requestParamBody, Session session) {
        return null;
    }

    public void execute(DataRowStream<T> var1);

    default public void close() {
    }

    default public Class<T> paramType() {
        Type superClass = this.getClass().getGenericInterfaces()[0];
        if (superClass instanceof Class) {
            throw new IllegalArgumentException("Internal error: TypeReference constructed without actual type information");
        }
        return (Class)((ParameterizedType)this.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
    }

    public static enum StreamProcessResult {
        SUCCESS,
        FAIL;

    }

    public static enum Result {
        SUCCESS,
        FAIL,
        EXISTS;

    }

    public static interface ImportConf<T extends RequestParamBody>
    extends Model {
        public T requestParam();

        public ImportPreDefConf importPreDefConf();
    }

    public static interface DataRow {
        public int segment();

        public int rowNum();

        public Map<String, Object> data();

        public Segment.Header.Cell header(String var1);
    }

    public static interface ImportContext {
        public void cancel();

        default public void reply(int fromRow, int toRow, String desc, Result result) {
            this.replyWithSegment(0, fromRow, toRow, desc, result);
        }

        default public void reply(int row, String desc, Result result) {
            this.reply(row, row, desc, result);
        }

        default public void replyWithSegment(int segment, int row, String desc, Result result) {
            this.replyWithSegment(segment, row, row, desc, result);
        }

        public void replyWithSegment(int var1, int var2, int var3, String var4, Result var5);
    }

    public static interface DataRowListener {
        public void onRow(DataRow var1, ImportContext var2);
    }

    public static interface DataRowStream<T extends RequestParamBody> {
        public DataRowStream<T> reset();

        public void subscribe(DataRowListener var1);

        public int segmentCount();

        public long rowCount();

        public long rowCount(int var1);

        public Session session();

        public ImportConf<T> importConf();

        public void mark(StreamProcessResult var1, String var2);
    }

    public static class DataRowImpl
    implements DataRow {
        private int segment;
        private int rowNum;
        Map<String, Object> data;
        private transient HeaderLookup headerLookup;

        @Override
        public int segment() {
            return this.segment;
        }

        @Override
        public int rowNum() {
            return this.rowNum;
        }

        @Override
        public Map<String, Object> data() {
            return this.data;
        }

        @Override
        public Segment.Header.Cell header(String path) {
            return this.headerLookup.lookup(path);
        }

        public int getSegment() {
            return this.segment;
        }

        public int getRowNum() {
            return this.rowNum;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public HeaderLookup getHeaderLookup() {
            return this.headerLookup;
        }

        public void setSegment(int segment) {
            this.segment = segment;
        }

        public void setRowNum(int rowNum) {
            this.rowNum = rowNum;
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }

        public void setHeaderLookup(HeaderLookup headerLookup) {
            this.headerLookup = headerLookup;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataRowImpl)) {
                return false;
            }
            DataRowImpl other = (DataRowImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSegment() != other.getSegment()) {
                return false;
            }
            if (this.getRowNum() != other.getRowNum()) {
                return false;
            }
            Map<String, Object> this$data = this.getData();
            Map<String, Object> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataRowImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSegment();
            result = result * 59 + this.getRowNum();
            Map<String, Object> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "JobInTaskFlow.DataRowImpl(segment=" + this.getSegment() + ", rowNum=" + this.getRowNum() + ", data=" + this.getData() + ", headerLookup=" + this.getHeaderLookup() + ")";
        }
    }

    public static interface HeaderLookup {
        public Segment.Header.Cell lookup(String var1);
    }

    public static interface ImportTaskInfoProvider {
        public String name();
    }
}

