/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.client.ClientNode;
import com.ovopark.iohub.sdk.client.ClientNodeRegister;
import com.ovopark.iohub.sdk.client.ControlTransport;
import com.ovopark.iohub.sdk.client.IOHubClientConfig;
import com.ovopark.iohub.sdk.client.IOTtlCache;
import com.ovopark.iohub.sdk.client.JobClientActive;
import com.ovopark.iohub.sdk.client.outstream.ExportEndpoint;
import com.ovopark.iohub.sdk.model.ClientNodeRegisterRequest;
import com.ovopark.iohub.sdk.model.ClientNodeRegisterResponse;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.TtlCacheServiceV2;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@JobClientActive
@Component
public class ClientNodeRegisterImpl
implements ClientNodeRegister,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ClientNodeRegisterImpl.class);
    @Autowired
    private ClientNodeRegister.ClientNodeProvider clientNodeProvider;
    static final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    @Autowired
    ControlTransport controlTransport;
    @Autowired
    private IOHubClientConfig ioHubClientConfig;
    private final TtlCacheServiceV2<String> ttlCacheServiceV2 = TtlCacheServiceV2.impl();
    final boolean verbose = Config.ConfigPriority.option().getBoolean("iohub.client.node.verbose", Boolean.valueOf(false));

    @Override
    public void register() {
        Util.schedule((ScheduledExecutorService)scheduledExecutorService, () -> {
            ClientNode clientNode = this.clientNodeProvider.clientNode();
            ClientNodeRegisterRequest clientNodeRegisterRequest = new ClientNodeRegisterRequest();
            clientNodeRegisterRequest.setVersion(1);
            clientNodeRegisterRequest.setMinVersion(34);
            clientNodeRegisterRequest.setApp(clientNode.app());
            clientNodeRegisterRequest.setNode(clientNode.node());
            clientNodeRegisterRequest.setIp(clientNode.ip());
            clientNodeRegisterRequest.setPort(clientNode.port());
            clientNodeRegisterRequest.setServletPath(clientNode.servletPath());
            clientNodeRegisterRequest.setTaskModelList(ExportEndpoint.JobTaskManager.getOrCreate().taskList());
            clientNodeRegisterRequest.setNfsPath(this.ioHubClientConfig.nfsPath());
            final String nodeRootPath = this.ioHubClientConfig.nfsPath() + "/client-" + clientNode.node();
            clientNodeRegisterRequest.setNodeRootPath(nodeRootPath);
            String nfsCheckContent = (String)IOTtlCache.getOrCreate().putIfAbsentAndGet((Comparable)((Object)(ClientNode.UUID_STR + ":nfs-check")), (Supplier)new Supplier<String>(){

                @Override
                public String get() {
                    String nfsPath = ClientNodeRegisterImpl.this.ioHubClientConfig.nfsPath();
                    String nfsCheckContent = Util.uniqueFirstPart();
                    try {
                        File file = new File(nodeRootPath + "/nfs-check");
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        Util.writeAtomic((File)file, (byte[])Util.utf8((String)nfsCheckContent));
                    }
                    catch (IOException e) {
                        return e.getMessage();
                    }
                    return nfsCheckContent;
                }
            }, 15L, TimeUnit.SECONDS);
            clientNodeRegisterRequest.setNfsCheckContent(nfsCheckContent);
            ClientNodeRegisterResponse clientNodeRegisterResponse = this.controlTransport.heartbeat(clientNodeRegisterRequest);
            log.debug(JSONAccessor.impl().format((Object)clientNodeRegisterResponse));
        }, (long)5L, (TimeUnit)TimeUnit.SECONDS, e -> {
            log.debug(e.getMessage());
            return true;
        }, () -> true);
    }

    public void run(String ... args) throws Exception {
        this.register();
    }
}

