/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.client.Client2WorkTransport;
import com.ovopark.iohub.sdk.client.ClientNode;
import com.ovopark.iohub.sdk.client.outstream.Writer;
import com.ovopark.iohub.sdk.model.AppNode;
import com.ovopark.iohub.sdk.model.outstream.ExportPushCommitRequest;
import com.ovopark.iohub.sdk.model.outstream.ExportPushCommitResponse;
import com.ovopark.iohub.sdk.model.outstream.ExportPushDataRequest;
import com.ovopark.iohub.sdk.model.outstream.ExportPushDataResponse;
import com.ovopark.iohub.sdk.model.proto.HeaderImpl;
import com.ovopark.iohub.sdk.model.proto.InMemoryOutStore;
import com.ovopark.iohub.sdk.model.proto.NFSOutStore;
import com.ovopark.iohub.sdk.model.proto.NFSSegmentModel;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.iohub.sdk.model.proto.SegmentImpl;
import com.ovopark.iohub.sdk.model.proto.TitleImpl;
import com.ovopark.kernel.shared.JSONAccessor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(HttpWriter.class);
    private final Client2WorkTransport client2WorkTransport;

    public HttpWriter(Client2WorkTransport client2WorkTransport) {
        this.client2WorkTransport = client2WorkTransport;
    }

    @Override
    public void writeAndCommit(List<Segment.SD> sdList, OutStore outStore, long taskId, ClientNode clientNode, AppNode worker) {
        if (outStore instanceof InMemoryOutStore) {
            ArrayList<SegmentImpl> list = new ArrayList<SegmentImpl>();
            for (Segment.SD sd : sdList) {
                Segment segment = outStore.segment(sd);
                list.add((SegmentImpl)segment);
            }
            ExportPushDataRequest exportPushDataRequest = new ExportPushDataRequest();
            exportPushDataRequest.setSegmentList(list);
            exportPushDataRequest.setTaskId(taskId);
            exportPushDataRequest.setApp(clientNode.app());
            exportPushDataRequest.setNode(clientNode.node());
            exportPushDataRequest.setWorkApp(worker.getApp());
            exportPushDataRequest.setWorkNode(worker.getNode());
            log.info("request push data checkpoint");
            ExportPushDataResponse exportPushDataResponse = this.client2WorkTransport.push(exportPushDataRequest);
            log.info("response push data checkpoint: " + JSONAccessor.impl().format((Object)exportPushDataResponse));
            if (exportPushDataResponse == null || !exportPushDataResponse.isSuccess()) {
                throw new IllegalStateException("cannot push data to worker:");
            }
            ExportPushCommitRequest exportPushCommitRequest = new ExportPushCommitRequest();
            exportPushCommitRequest.setFileName(((InMemoryOutStore)outStore).getFileName());
            exportPushCommitRequest.setTaskId(taskId);
            exportPushCommitRequest.setApp(clientNode.app());
            exportPushCommitRequest.setNode(clientNode.node());
            exportPushCommitRequest.setWorkApp(worker.getApp());
            exportPushCommitRequest.setWorkNode(worker.getNode());
            exportPushCommitRequest.setGroupMap(((InMemoryOutStore)outStore).getGroupMap());
            exportPushCommitRequest.setFeature(((InMemoryOutStore)outStore).getFeature());
            log.info("request commit checkpoint");
            ExportPushCommitResponse exportPushCommitResponse = this.client2WorkTransport.commit(exportPushCommitRequest);
            log.info("response commit checkpoint: " + JSONAccessor.impl().format((Object)exportPushCommitResponse));
            if (exportPushCommitResponse == null || !exportPushCommitResponse.isSuccess()) {
                throw new IllegalStateException("cannot commit data to worker:");
            }
        } else {
            ArrayList<NFSSegmentModel> nfsSegmentModelList = new ArrayList<NFSSegmentModel>();
            for (Segment.SD sd : sdList) {
                NFSSegmentModel nfsSegmentModel = new NFSSegmentModel();
                nfsSegmentModel.setName(sd.getName());
                nfsSegmentModel.setUrl(sd.getUrl());
                nfsSegmentModel.setMeta(sd.getMeta());
                nfsSegmentModel.setRowCount(sd.getRowCount());
                Segment segment = outStore.segment(sd);
                nfsSegmentModel.setTitle((TitleImpl)segment.title());
                nfsSegmentModel.setHeader((HeaderImpl)segment.header());
                nfsSegmentModel.setGroup(segment.group());
                nfsSegmentModelList.add(nfsSegmentModel);
            }
            ExportPushCommitRequest exportPushCommitRequest = new ExportPushCommitRequest();
            exportPushCommitRequest.setFileName(((NFSOutStore)outStore).getFileName());
            exportPushCommitRequest.setNfsSegmentModelList(nfsSegmentModelList);
            exportPushCommitRequest.setTaskId(taskId);
            exportPushCommitRequest.setApp(clientNode.app());
            exportPushCommitRequest.setNode(clientNode.node());
            exportPushCommitRequest.setWorkApp(worker.getApp());
            exportPushCommitRequest.setWorkNode(worker.getNode());
            exportPushCommitRequest.setGroupMap(((NFSOutStore)outStore).getGroupMap());
            exportPushCommitRequest.setFileIOUrl(((NFSOutStore)outStore).getFileIOUrl());
            exportPushCommitRequest.setFeature(((NFSOutStore)outStore).getFeature());
            log.info("request commit checkpoint");
            ExportPushCommitResponse exportPushCommitResponse = this.client2WorkTransport.commit(exportPushCommitRequest);
            log.info("response commit checkpoint: " + JSONAccessor.impl().format((Object)exportPushCommitResponse));
            if (exportPushCommitResponse == null || !exportPushCommitResponse.isSuccess()) {
                log.error("cannot commit data to worker:" + JSONAccessor.impl().format((Object)exportPushCommitResponse));
                throw new IllegalStateException("cannot commit data to worker:");
            }
        }
    }
}

