package com.ovopark.iohub.sdk.client;

import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import static com.ovopark.kernel.shared.Util.isEmpty;

@Slf4j
public class JobClientCondition implements Condition {

    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {

        // adapter  all version ???
        // spring > 5.2+
        // spring < 5.2
        boolean f = metadata.isAnnotated(JobClientActive.class.getName());
        if (!f) {
            return true;
        }

        //metadata.get
        String activeJobClient = context.getEnvironment().getProperty("IOHUB_JOB_CLIENT_ACTIVE");
        if ("off".equalsIgnoreCase(activeJobClient)) {
            log.warn("[off] inactive bean class: "+metadata.toString());
            return false;
        }
        if (isEmpty(activeJobClient)) {
            log.warn("[empty, as on] active bean class: "+metadata.toString());
            return true;
        }

        if (activeJobClient.equalsIgnoreCase("on") || activeJobClient.equalsIgnoreCase("true")) {
            log.warn("[on|true] active bean class: "+metadata.toString());
            return true;
        }

        return false;
    }
}
