package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.model.ClientNodeRegisterRequest;
import com.ovopark.iohub.sdk.model.ClientNodeRegisterResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@JobClientActive
@Slf4j
@Component
public class Work2ControlRestClient implements Work2ControlTransport {

    private final RestTemplate restTemplate;

    public Work2ControlRestClient() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(45_000);//ms
        factory.setConnectTimeout(15_000);//ms
        restTemplate = new RestTemplate(factory);
    }

    @Autowired
    private ControlNodeImpl appNode;

    @Override
    public ClientNodeRegisterResponse heartbeat(ClientNodeRegisterRequest clientNodeRegisterRequest) {
        return rpc(clientNodeRegisterRequest, "/worker/heartbeat",ClientNodeRegisterResponse.class);
    }

    private <T> T rpc(Object request, String path,Class<T> clazz) {
        String url = "http://"+appNode.ip() + ":" + appNode.port()+"/iohub-control" ;
        url+=path;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type","application/json");
        HttpEntity<String> formEntity = new HttpEntity<String>(JSONAccessor.impl().format(request), headers);
        try {
            ResponseEntity<String> responseEntity = restTemplate.postForEntity(url, formEntity, String.class);
            int statusCodeValue = responseEntity.getStatusCodeValue();
            if (statusCodeValue==200) {
                return JSONAccessor.impl().read(responseEntity.getBody(), clazz);
            }
            return null;
        } catch (Exception e) {
            log.error(e.getMessage(),e);
            return null;
        }
    }

}
