package com.ovopark.iohub.sdk.client.instream;

import com.ovopark.iohub.sdk.client.*;
import com.ovopark.iohub.sdk.client.outstream.RequestParamBody;
import com.ovopark.iohub.sdk.model.*;
import com.ovopark.iohub.sdk.model.instream.*;
import com.ovopark.iohub.sdk.model.proto.*;
import com.ovopark.kernel.shared.CachedExecutors;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.CacheService;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.module.shared.Session;
import com.ovopark.module.shared.spring.rbac.SessionImpl;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

import static com.ovopark.kernel.shared.Util.*;

@JobClientActive
@Slf4j
@RestController("com.ovopark.iohub.sdk.client.instream.ImportEndpoint")
@RequestMapping("/feign/iohub-job/processing/import")
public class ImportEndpoint implements InitializingBean {

    @Autowired
    private Client2ControlTransport client2ControlTransport;

    private static final ExecutorService jobExecutor = new ThreadPoolExecutor(
            Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2,64)
                    , Integer.parseInt(System.getProperty("IOHUB_IMPORT_IO", "0")))
            , Math.max(Math.max(Runtime.getRuntime().availableProcessors() * 2,1024)
            , Integer.parseInt(System.getProperty("IOHUB_IMPORT_IO", "0")))
            , 600, TimeUnit.SECONDS
            //Integer.MAX_VALUE ???
            , new LinkedBlockingQueue(1)
            , newThreadFactory("iohub-import-io")
            , new ThreadPoolExecutor.AbortPolicy());

    private static final CacheService<String, ImportPushDataRequest> C=new CacheService.MapCacheService<>(true
            , CachedExecutors.impl("iohub-import-io-c",1,1)
            );

//    @Autowired
//    private JobTaskExecutor jobTaskExecutor;

    final private Set<Long> executingJobTaskIdSet = ConcurrentHashMap.newKeySet();

    final Map<String,SubmitTask> submitTaskMap=new ConcurrentHashMap<>();


    @Autowired
    private IOHubClientConfig ioHubClientConfig;

    @Autowired
    private JobInTaskFlowProvider jobInTaskFlowProvider;

    @Autowired
    private ClientNodeRegister.ClientNodeProvider clientNodeProvider;


    @RequestMapping("/submit")
    @ResponseBody
    public ImportPushDataResponse submit(@RequestBody ImportPushDataRequest importPushDataRequest){
        final String taskKey = "task_" + importPushDataRequest.getTaskId();
        MDC.put("traceId", taskKey);
        MDC.put("requestId", taskKey);
        log.info("receive a new task, we can do it???: "+JSONAccessor.impl().format(importPushDataRequest));
        final ImportPushDataResponse importPushDataResponse=new ImportPushDataResponse();
        importPushDataResponse.setSuccess(false);
        final JobLog jobLog = new JobLogImpl(client2ControlTransport, 300, taskKey);
        try {
            lock(taskKey, new Callable<Void>() {
                @Override
                public Void call() throws Exception {
                    // same task is submit in the same node , 10min???
                    // skip the same task ??? task id + task history id
                    C.putIfAbsentAndGet(taskKey, new Supplier<ImportPushDataRequest>() {
                        @Override
                        public ImportPushDataRequest get() {

                            if (executingJobTaskIdSet.contains(importPushDataRequest.getTaskId())) {
                                importPushDataResponse.setSuccess(false);
                                importPushDataResponse.setDesc("Rejected,the previous task is executing");
                                throw new IllegalStateException("the previous task is executing, reject the task: "
                                        +JSONAccessor.impl().format(importPushDataRequest));
                            }

                            TaskLockRequest taskLockRequest=new TaskLockRequest();
                            taskLockRequest.setTaskId(importPushDataRequest.getTaskId());
                            taskLockRequest.setNode(ClientNode.UUID_STR);
                            TaskLockResponse taskLockResponse = client2ControlTransport.lockClient(taskLockRequest);
                            if (taskLockResponse == null || !taskLockResponse.isSuccess()) {
                                throw new IllegalStateException("cannot get lock: "+ JSONAccessor.impl().format(taskLockRequest));
                            }

                            executingJobTaskIdSet.add(importPushDataRequest.getTaskId());

                            //process pre flow ...
                            final long taskId=importPushDataRequest.getTaskId();
                            final String uri=importPushDataRequest.getJobMeta().getUri();
                            final String args = importPushDataRequest.getArgs();
                            final ImportPreDefParam preDefParam = importPushDataRequest.getPreDefParam();
                            final String session=importPushDataRequest.getSession();
                            final JobMeta jobMeta=importPushDataRequest.getJobMeta();
                            final AppNode worker=importPushDataRequest.getWorker();
                            final ImportEndpoint.JobTaskManager jobTaskManager=new JobTaskManager() {
                                @Override
                                public void cancel(long taskId) {
                                    SubmitTask submitTask = submitTaskMap.get("task_" +taskId);
                                    submitTask.future.cancel(true);
                                    Stream.from("cancel the task").subscribe(s -> {
                                        log.info(s);
                                        jobLog.log(s);
                                    });
                                }
                            };

                            ClientNode clientNode = clientNodeProvider.clientNode();

                            SessionImpl si = Util.isEmpty(session)?null: JSONAccessor.impl().read(session, SessionImpl.class);
                            SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
                            factory.setReadTimeout(45_000);//ms
                            factory.setConnectTimeout(15_000);//ms
                            RestTemplate restTemplate = new RestTemplate(factory);
                            restTemplate.getMessageConverters().add(0,new StringHttpMessageConverter(StandardCharsets.UTF_8));
                            Client2WorkTransport client2WorkTransport =new Client2WorkRestClient(worker,restTemplate);
                            Stream.from("accepted , to import data??? : ").subscribe(s -> {
                                log.info(s);
                                jobLog.log(s);
                            });
                            JobInTaskFlow<RequestParamBody> jobInTaskFlow = jobInTaskFlowProvider.find(uri);
                            boolean taskSubmit=false;
                            try {
                                //prepared
                                jobInTaskFlow.prepared();
                                Stream.from("prepare bean : ").subscribe(s -> {
                                    log.info(s);
                                    jobLog.log(s);
                                });

                                // request param
                                ImportPreDefConfImpl importPreDefConf=new ImportPreDefConfImpl();
                                importPreDefConf.setDataExistStrategy(preDefParam.getDataExistStrategy());

                                RequestParamBody requestParamBody;
                                try {
                                    log.info(" to parse args: "+args);
                                    requestParamBody = isEmpty(args)?null:jobInTaskFlow.requestParamBody(args, si);
                                }
                                catch (NoPrivilegeException e) {
                                    importPushDataResponse.setSuccess(false);
                                    importPushDataResponse.setDesc("no privilege");
                                    throw new IllegalStateException("no privilege, reject the task: "
                                            +JSONAccessor.impl().format(args+", session: "+JSONAccessor.impl().format(si)));
                                }catch (Exception e){
                                    importPushDataResponse.setSuccess(false);
                                    importPushDataResponse.setDesc(e.getMessage());
                                    log.error(e.getMessage(),e);
                                    throw new IllegalStateException("error, reject the task: "+e.getMessage()
                                            +JSONAccessor.impl().format(args+", session: "+JSONAccessor.impl().format(si)));
                                }

                                JobInTaskFlow.ImportTaskInfoProvider importTaskInfoProvider = jobInTaskFlow.importTaskInfoProvider(requestParamBody,si);
                                Stream.from("update import record  , import record id: "+1).subscribe(s -> {
                                    log.info(s);
                                    jobLog.log(s);
                                });
                                //query & export ???
//                                OutStore outStore;
//                                if (jobMeta.isNfs()) {
//                                    outStore=new NFSOutStore(ioHubClientConfig.nfsPath()+"/client-"+ClientNode.UUID_STR,1);
//                                }
//                                else {
//                                    outStore=new InMemoryOutStore(Math.min(jobMeta.getSegmentCount(),10));
//                                }
//                                log.info("create out store , nfs ? : "+jobMeta.isNfs());
//                                jobLog.log("create out store , nfs ? : "+jobMeta.isNfs());
                                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor
                                        =new ScheduledThreadPoolExecutor(
                                        1,newThreadFactory("tmp"),new ThreadPoolExecutor.CallerRunsPolicy());
                                scheduledThreadPoolExecutor.setKeepAliveTime(60,TimeUnit.SECONDS);
                                scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);

                                ClientNodeTaskRegisterRequest clientNodeTaskRegisterRequest=new ClientNodeTaskRegisterRequest();
                                clientNodeTaskRegisterRequest.setTaskId(taskId);
                                clientNodeTaskRegisterRequest.setApp(clientNode.app());
                                clientNodeTaskRegisterRequest.setNode(clientNode.node());
                                clientNodeTaskRegisterRequest.setWorkApp(worker.getApp());
                                clientNodeTaskRegisterRequest.setWorkNode(worker.getNode());

                                try {
                                    Future<?> future = jobExecutor.submit(catchRunnable(() -> {
                                        //OK , start doing real task logic
                                        final JobLog jobLog = new JobLogImpl(client2ControlTransport, 300, taskKey);
                                        try {
                                            doTask(new Callable<Void>() {
                                                @Override
                                                public Void call() throws Exception {
                                                    Stream.from("to import all data ").subscribe(s -> {
                                                        log.info(s);
                                                        jobLog.log(s);
                                                    });
                                                    jobLog.flush();

                                                    ReplyModel replyModel=new ReplyModel();
                                                    final Map<String,ReplyRowModel> replyModelIndex=new HashMap<>();
                                                    AtomicBoolean cancelled=new AtomicBoolean(false);
                                                    JobInTaskFlow.ImportContext importContext =new JobInTaskFlow.ImportContext() {
                                                        @Override
                                                        public void cancel() {
                                                            cancelled.set(true);
                                                        }

                                                        @Override
                                                        public synchronized void replyWithSegment(int segment, int fromRow, int toRow, String desc, JobInTaskFlow.Result result) {
                                                            if (result== JobInTaskFlow.Result.EXISTS) {
                                                                replyModel.setRepeatCount(replyModel.getRepeatCount()+1);
                                                            }
                                                            else if (result== JobInTaskFlow.Result.SUCCESS) {
                                                                replyModel.setSuccessCount(replyModel.getSuccessCount()+1);
                                                            }
                                                            else if (result== JobInTaskFlow.Result.FAIL) {
                                                                replyModel.setErrorCount(replyModel.getErrorCount()+1);
                                                            }
                                                            String key=segment+":"+fromRow+":"+toRow;
                                                            ReplyRowModel rrm = replyModelIndex.get(key);
                                                            if (rrm==null) {
                                                                ReplyRowModel replyRowModel = ReplyRowModel.replyWithSegment(segment, fromRow, toRow, desc);
                                                                replyModel.add(replyRowModel);
                                                                replyModelIndex.put(key,replyRowModel);
                                                            }
                                                            else {
                                                                if (rrm.getDescList().size()>100) {
                                                                    return;
                                                                }
                                                                rrm.getDescList().add(desc);
                                                            }
                                                        }
                                                    };

                                                    JobInTaskFlow.ImportConf<RequestParamBody> importConf=new JobInTaskFlow.ImportConf<RequestParamBody>() {
                                                        @Override
                                                        public RequestParamBody requestParam() {
                                                            return requestParamBody;
                                                        }

                                                        @Override
                                                        public ImportPreDefConf importPreDefConf() {
                                                            return importPreDefConf;
                                                        }
                                                    };

                                                    final List<SegmentImpl> segmentList = importPushDataRequest.getSegmentList();
                                                    int segmentCount = segmentList.size();
                                                    int rowCount=0;
                                                    for (SegmentImpl segment : segmentList) {
                                                        rowCount+=segment.size();
                                                    }
                                                    int finalRowCount = rowCount;
                                                    JobInTaskFlow.DataRowStream<RequestParamBody> dataRowStream =new JobInTaskFlow.DataRowStream<RequestParamBody>() {
                                                        final AtomicBoolean reset=new AtomicBoolean(true);

                                                        @Override
                                                        public JobInTaskFlow.DataRowStream<RequestParamBody> reset() {
                                                            cancelled.set(false);
                                                            return this;
                                                        }

                                                        @Override
                                                        public void mark(JobInTaskFlow.StreamProcessResult streamProcessResult, String msg) {
                                                            if (streamProcessResult== JobInTaskFlow.StreamProcessResult.SUCCESS) {
                                                                replyModel.setStatus(1);
                                                            }
                                                            else if (streamProcessResult== JobInTaskFlow.StreamProcessResult.FAIL) {
                                                                replyModel.setStatus(-1);
                                                                replyModel.setFailMsg(msg);
                                                            }
                                                        }

                                                        @Override
                                                        public void subscribe(JobInTaskFlow.DataRowListener dataRowListener) {
                                                            if (!reset.get()) {
                                                                throw new IllegalStateException("need reset stream before subscribe it.");
                                                            }
                                                            for (int segmentIndex = 0; segmentIndex < segmentList.size(); segmentIndex++) {
                                                                if (cancelled.get()) {
                                                                    Stream.from("cancel the import flow, segment: "+segmentIndex).subscribe(s -> {
                                                                        log.info(s);
                                                                        jobLog.log(s);
                                                                    });
                                                                    reset.set(false);
                                                                    return;
                                                                }
                                                                Segment segment=segmentList.get(segmentIndex);
                                                                final Map<String, Segment.Header.Cell> headerCellMap=new HashMap<>();
                                                                segment.header().scanUp2Down(new Segment.Header.Scan() {
                                                                    @Override
                                                                    public void scan(Segment.Header.Cell cell) {
                                                                        headerCellMap.put(cell.path(),cell);
                                                                    }
                                                                });
                                                                JobInTaskFlow.HeaderLookup headerLookup=new JobInTaskFlow.HeaderLookup() {
                                                                    @Override
                                                                    public Segment.Header.Cell lookup(String path) {
                                                                        return headerCellMap.get(path);
                                                                    }
                                                                };
                                                                List<Map<String, Object>> mapList = segment.rowList();
                                                                for (int rowIndex = 0; rowIndex < mapList.size(); rowIndex++) {
                                                                    if (cancelled.get()) {
                                                                        Stream.from("cancel the import flow, segment: "+segmentIndex).subscribe(s -> {
                                                                            log.info(s);
                                                                            jobLog.log(s);
                                                                        });
                                                                        reset.set(false);
                                                                        return;
                                                                    }
                                                                    Map<String, Object> data = mapList.get(rowIndex);
                                                                    boolean allEmpty=true;
                                                                    for (Object v : data.values()) {
                                                                        if (isNotEmpty((String)v)) {
                                                                            allEmpty=false;
                                                                            break;
                                                                        }
                                                                    }

                                                                    if (allEmpty) {
                                                                        continue;
                                                                    }


                                                                    JobInTaskFlow.DataRowImpl dataRow=new JobInTaskFlow.DataRowImpl();
                                                                    dataRow.setSegment(segmentIndex);
                                                                    dataRow.setRowNum(rowIndex);
                                                                    dataRow.setData(data);
                                                                    dataRow.setHeaderLookup(headerLookup);
                                                                    dataRowListener.onRow(dataRow, importContext);
                                                                }
                                                            }
                                                            reset.set(false);
                                                        }

                                                        @Override
                                                        public int segmentCount() {
                                                            return segmentCount;
                                                        }

                                                        @Override
                                                        public long rowCount() {
                                                            return finalRowCount;
                                                        }

                                                        @Override
                                                        public long rowCount(int segment) {
                                                            return segmentList.get(segment).size();
                                                        }

                                                        @Override
                                                        public Session session() {
                                                            return si;
                                                        }

                                                        @Override
                                                        public JobInTaskFlow.ImportConf<RequestParamBody> importConf() {
                                                            return importConf;
                                                        }
                                                    };
                                                    try {
                                                        jobInTaskFlow.execute(dataRowStream);
                                                    } catch (Throwable e) {
                                                        log.error("job in task flow error: "+e.getMessage(),e);
                                                        jobLog.log("job in task flow error: "+e.getMessage());
                                                        throw convert2RuntimeException(e);
                                                    }

                                                    Stream.from("import all data , then push reply to work").subscribe(s -> {
                                                        log.info(s);
                                                        jobLog.log(s);
                                                    });

                                                    jobLog.flush();
                                                    ImportReplyRequest importReplyRequest=new ImportReplyRequest();
                                                    importReplyRequest.setTaskId(taskId);
                                                    importReplyRequest.setApp(clientNode.app());
                                                    importReplyRequest.setNode(clientNode.node());
                                                    importReplyRequest.setWorkApp(worker.getApp());
                                                    importReplyRequest.setWorkNode(worker.getNode());

                                                    importReplyRequest.setReplyModel(replyModel);

                                                    ImportReplyResponse importReplyResponse = client2WorkTransport.importReply(importReplyRequest);
                                                    Stream.from("reply result: "+JSONAccessor.impl().format(importReplyResponse)).subscribe(s -> {
                                                        log.info(s);
                                                        jobLog.log(s);
                                                    });
                                                    if (importReplyResponse==null|| !importReplyResponse.isSuccess()) {
                                                        Stream.from("push reply fail???").subscribe(s -> {
                                                            log.info(s);
                                                            jobLog.log(s);
                                                        });
                                                    }
                                                    ImportCommitRequest importCommitRequest=new ImportCommitRequest();
                                                    importCommitRequest.setTaskId(taskId);
                                                    importCommitRequest.setApp(clientNode.app());
                                                    importCommitRequest.setNode(clientNode.node());
                                                    importCommitRequest.setWorkApp(worker.getApp());
                                                    importCommitRequest.setWorkNode(worker.getNode());

                                                    ImportCommitResponse importCommitResponse = client2WorkTransport.importCommit(importCommitRequest);
                                                    Stream.from("commit result: "+JSONAccessor.impl().format(importCommitResponse)).subscribe(s -> {
                                                        log.info(s);
                                                        jobLog.log(s);
                                                    });
                                                    if (importCommitResponse==null|| !importCommitResponse.isSuccess()) {
                                                        Stream.from("push commit fail???").subscribe(s -> {
                                                            log.info(s);
                                                            jobLog.log(s);
                                                        });
                                                    }

                                                    Stream.from("task completed, and all reply pushed to worker, wait worker generate xlsx???").subscribe(s -> {
                                                        log.info(s);
                                                        jobLog.log(s);
                                                    });
                                                    return null;
                                                }
                                            }, client2WorkTransport,clientNodeTaskRegisterRequest,scheduledThreadPoolExecutor,taskId,jobMeta,jobTaskManager);
                                        }
                                        catch (Exception e){
                                            jobLog.log("error: "+e.getMessage());
                                            throw convert2RuntimeException(e);
                                        }
                                        finally {
                                            try {
                                                submitTaskMap.remove(taskKey);
                                            }catch (Exception e){
                                                log.error(e.getMessage(),e);
                                            }
                                            executingJobTaskIdSet.remove(taskLockRequest.getTaskId());
                                            try {
                                                jobLog.log(taskKey + " > completed: " + formatTime(LocalDateTime.now()));
                                                jobLog.flush();
                                                jobLog.close();
                                            } catch (Exception e) {
                                                log.error(e.getMessage(), e);
                                            }

                                            try {
                                                jobInTaskFlow.close();
                                            } catch (Exception e) {
                                                log.error(e.getMessage(), e);
                                            }

                                        }
                                    }));

                                    taskSubmit=true;

                                    SubmitTask submitTask=new SubmitTask();
                                    submitTask.setTaskId(importPushDataRequest.getTaskId());
                                    submitTask.setFuture(future);
                                    submitTask.setTaskModel(new TaskModel());

                                    submitTask.getTaskModel().setJobTaskId(importPushDataRequest.getTaskId());
                                    submitTask.getTaskModel().setWorkNode(importPushDataRequest.getWorker().getNode());
                                    submitTask.getTaskModel().setClientNode(ClientNode.UUID_STR);
                                    submitTask.getTaskModel().setAcceptTime(System.currentTimeMillis());
                                    submitTask.getTaskModel().setAcceptTimeStr(formatTime(LocalDateTime.now()));
                                    submitTaskMap.put(taskKey,submitTask);
                                    log.info("OK, the task is scheduled: "+taskKey);
                                    //OK ,  resource is available , executor accepts the task
                                    importPushDataResponse.setSuccess(true);
                                } catch (RejectedExecutionException e) {
                                    // resource is unavailable
                                    executingJobTaskIdSet.remove(taskLockRequest.getTaskId());
                                    importPushDataResponse.setSuccess(false);
                                    importPushDataResponse.setDesc("Rejected, resource is unavailable ");
                                    throw convert2RuntimeException(e);
                                }

                            }
                            catch (Exception e){
                                jobLog.log("error : "+e.getMessage());
                                throw convert2RuntimeException(e);
                            }
                            finally {
                                if (!taskSubmit) {
                                    jobInTaskFlow.close();
                                }
                            }
                            return importPushDataRequest;
                        }
                    }, 60, TimeUnit.SECONDS);

                    return null;
                }
            },10,TimeUnit.SECONDS);

        }
        catch (Exception e) {
            log.error(e.getMessage(),e);
            importPushDataResponse.setSuccess(false);
            importPushDataResponse.setDesc(e.getMessage());
        }
        finally {
            try {
                jobLog.close();
            }
            catch (Exception e){
                log.error(e.getMessage(),e);
            }
            finally {
                MDC.remove("traceId");
                MDC.remove("requestId");
            }
        }
        return importPushDataResponse;
    }

    @Data
    public static class SubmitTask{

        private long taskId;

        private Future<?> future;

        private TaskModel taskModel;

    }

    public interface JobTaskManager{

        void cancel(long taskId);

        default List<TaskModel> taskList(){throw new UnsupportedOperationException();}

        static JobTaskManager getOrCreate(){
            return instance;
        }

    }

    @Override
    public void afterPropertiesSet() throws Exception {
        instance=simpleJobTaskManager;
    }

    private static JobTaskManager instance;

    final private SimpleJobTaskManager simpleJobTaskManager=new SimpleJobTaskManager();

    private class SimpleJobTaskManager implements JobTaskManager{

        @Override
        public void cancel(long taskId) {
            SubmitTask submitTask = submitTaskMap.get("task_" +taskId);
            if (submitTask==null) {
                return;
            }
            if (submitTask.future==null) {
                return;
            }
            submitTask.future.cancel(true);
            log.info("cancel the task");
        }

        @Override
        public List<TaskModel> taskList() {
            List<TaskModel> taskModelList=new ArrayList<>(submitTaskMap.size());
            for (SubmitTask submitTask : submitTaskMap.values()) {
                taskModelList.add(submitTask.getTaskModel());
            }
            return taskModelList;
        }


    }


    private <T> T doTask(Callable<T> callable, Client2WorkTransport client2WorkTransport
            , ClientNodeTaskRegisterRequest clientNodeTaskRegisterRequest
            , ScheduledExecutorService taskHeartbeat
            , long taskId
            , JobMeta jobMeta
            , ImportEndpoint.JobTaskManager jobTaskManager
    ){
        ScheduledFuture<?> scheduledFuture = taskHeartbeat.scheduleWithFixedDelay(catchRunnable(new CatchRunnable() {

            int failCount=0;

            @Override
            public void run() throws Exception {
                ClientNodeTaskRegisterResponse clientNodeTaskRegisterResponse = client2WorkTransport.importHeartbeat(clientNodeTaskRegisterRequest);
                log.info("heartbeat from work("+clientNodeTaskRegisterRequest.getWorkApp()+":"+clientNodeTaskRegisterRequest.getWorkNode()+") : "+JSONAccessor.impl().format(clientNodeTaskRegisterResponse));
                if (clientNodeTaskRegisterResponse==null || !clientNodeTaskRegisterResponse.isSuccess()) {
                    failCount++;
                    if (failCount>3) {
                        //OK , we lose connect to work... , break the task ???
                        // true , if memory , nfs ???
                        jobTaskManager.cancel(taskId);
                    }
                    return;
                }
                failCount=0;
            }
        }), 0, 5, TimeUnit.SECONDS);
        try {
            return callable.call();
        } catch (Exception e) {
            throw convert2RuntimeException(e);
        } finally {
            scheduledFuture.cancel(true);
            log.info("cancel heartbeat thread");
        }

    }


}
