package com.ovopark.iohub.sdk.client.outstream.test;

import com.ovopark.iohub.sdk.client.*;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlowProvider;
import com.ovopark.iohub.sdk.client.outstream.RequestParamBody;
import com.ovopark.iohub.sdk.model.AppNode;
import com.ovopark.iohub.sdk.model.outstream.ExportPushCommitRequest;
import com.ovopark.iohub.sdk.model.outstream.ExportPushDataRequest;
import com.ovopark.iohub.sdk.model.outstream.ExportPushDataResponse;
import com.ovopark.iohub.sdk.model.proto.*;
import com.ovopark.iohub.sdk.model.test.ExportRenderResponse;
import com.ovopark.iohub.sdk.model.test.ExportStartResponse;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.BaseResult;
import com.ovopark.module.shared.Session;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

import static com.ovopark.kernel.shared.Util.*;

@JobClientActive
@Slf4j
@RestController("com.ovopark.iohub.sdk.client.outstream.test.ExportLocalTestEndpoint")
@RequestMapping("/feign/iohub-job/processing/only-test/export")
public class ExportLocalTestEndpoint {

    final String workIp= Config.ConfigPriority.option().getString("iohub.client.io.work.ip","8.139.4.155");

    final int workPort= Config.ConfigPriority.option().getInt("iohub.client.io.work.port",13950);

    @Autowired
    private Client2ControlTransport client2ControlTransport;
    @Autowired
    private IOHubClientConfig ioHubClientConfig;

    @Autowired
    private JobOutTaskFlowProvider jobOutTaskFlowProvider;

    @Autowired
    private ClientNodeRegister.ClientNodeProvider clientNodeProvider;


    @RequestMapping("/submit")
    public BaseResult<?> submit(@RequestBody ExportTaskVo exportTaskVo
            , @RequestHeader(value = "nfs",required = false) boolean nfs
            , @RequestHeader(value = "ovo-authorization",required = false) String token
    ){

        final String uri = exportTaskVo.getUri();
        log.info("uri: "+JSONAccessor.impl().format(uri));

        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(45_000);//ms
        factory.setConnectTimeout(15_000);//ms
        RestTemplate restTemplate = new RestTemplate(factory);
        restTemplate.getMessageConverters().add(0,new StringHttpMessageConverter(StandardCharsets.UTF_8));
        AppNode appNode=new AppNode();
        appNode.setIp(workIp);
        appNode.setPort(workPort);
        appNode.setServletPath("iohub-work");
        Client2WorkRestClient client2WorkRestClient=new Client2WorkRestClient(appNode,restTemplate);
        ExportStartResponse exportStartResponse = client2WorkRestClient.startOnlyForTest(uri);
        final long taskId = exportStartResponse.getTaskId();
        log.info("taskId: "+JSONAccessor.impl().format(exportStartResponse));

        JobOutTaskFlow<RequestParamBody> jobOutTaskFlow = jobOutTaskFlowProvider.find(uri);
        jobOutTaskFlow.prepared();
        Session si = Session.getOrCreate().get();
        if (si==null && isNotEmpty(token)) {
            si=client2WorkRestClient.parseSessionOnlyForTest(token);
        }
        RequestParamBody requestParamBody = isEmpty(exportTaskVo.getParamMap())?null:jobOutTaskFlow.requestParamBody(
                JSONAccessor.impl().format(exportTaskVo.getParamMap()), si);
        JobOutTaskFlow.ExportTaskInfoProvider exportTaskInfoProvider = jobOutTaskFlow.exportTaskInfoProvider(requestParamBody, si);
        log.info(" export record , name: "+(exportTaskInfoProvider==null?null:exportTaskInfoProvider.name()));
        OutStore outStore;
        if (nfs) {
            outStore=new NFSOutStore("d:/iohub/client/client-"+ClientNode.UUID_STR,1);
        }
        else {
            outStore=new InMemoryOutStore(Math.min(1,10));
        }

        try {
            jobOutTaskFlow.execute(requestParamBody,outStore);
            outStore.commit();
        }
        catch (Exception e){
            throw convert2RuntimeException(e);
        }
        finally {
            outStore.close();
            jobOutTaskFlow.close();
        }

        log.info("execute completed , then we collect all data???");

        List<Segment.SD> sdList = outStore.sdList();
        if(outStore instanceof NFSOutStore){
            //NFS
            List<NFSSegmentModel> nfsSegmentModelList=new ArrayList<>();
            for (Segment.SD sd : sdList) {
                NFSSegmentModel nfsSegmentModel=new NFSSegmentModel();
                nfsSegmentModel.setName(sd.getName());
                nfsSegmentModel.setUrl(sd.getUrl());
                nfsSegmentModel.setMeta(sd.getMeta());
                nfsSegmentModel.setRowCount(sd.getRowCount());
                Segment segment = outStore.segment(sd);
                nfsSegmentModel.setTitle((TitleImpl) segment.title());
                nfsSegmentModel.setHeader((HeaderImpl) segment.header());
                nfsSegmentModel.setGroup(segment.group());

                nfsSegmentModelList.add(nfsSegmentModel);
            }

            ExportPushCommitRequest exportPushCommitRequest =new ExportPushCommitRequest();
            exportPushCommitRequest.setFileName(((NFSOutStore) outStore).getFileName());
            exportPushCommitRequest.setNfsSegmentModelList(nfsSegmentModelList);

            exportPushCommitRequest.setTaskId(0);
            exportPushCommitRequest.setApp(null);
            exportPushCommitRequest.setNode(null);
            exportPushCommitRequest.setWorkApp(null);
            exportPushCommitRequest.setWorkNode(null);
            exportPushCommitRequest.setGroupMap(((NFSOutStore) outStore).getGroupMap());
            exportPushCommitRequest.setFeature(((NFSOutStore) outStore).getFeature());
            log.info(JSONAccessor.impl().format(exportPushCommitRequest));

            String localFile = write2LocalFile(((NFSOutStore) outStore).getPath(), JSONAccessor.impl().format(exportPushCommitRequest));
            log.info("local file: "+localFile);

        }

        else {
            // memory
            List<SegmentImpl> list=new ArrayList<>();
            for (Segment.SD sd : sdList) {
                Segment segment = outStore.segment(sd);
                list.add((SegmentImpl) segment);
            }

            ExportPushDataRequest exportPushDataRequest =new ExportPushDataRequest();
            exportPushDataRequest.setSegmentList(list);

            exportPushDataRequest.setTaskId(taskId);
            exportPushDataRequest.setApp(null);
            exportPushDataRequest.setNode(null);
            exportPushDataRequest.setWorkApp(null);
            exportPushDataRequest.setWorkNode(null);

            ExportPushDataResponse exportPushDataResponse = client2WorkRestClient.pushOnlyForTest(exportPushDataRequest);
            log.info("exportPushDataResponse: "+JSONAccessor.impl().format(exportPushDataResponse));
            if (exportPushDataResponse==null || !exportPushDataResponse.isSuccess()) {
                throw new IllegalStateException("error, push data");
            }

            ExportPushCommitRequest exportPushCommitRequest =new ExportPushCommitRequest();
            exportPushCommitRequest.setFileName(((InMemoryOutStore) outStore).getFileName());

            exportPushCommitRequest.setTaskId(taskId);
            exportPushCommitRequest.setApp(null);
            exportPushCommitRequest.setNode(null);
            exportPushCommitRequest.setWorkApp(null);
            exportPushCommitRequest.setWorkNode(null);

            exportPushCommitRequest.setGroupMap(((InMemoryOutStore) outStore).getGroupMap());
            exportPushCommitRequest.setFeature(((InMemoryOutStore) outStore).getFeature());

            ExportRenderResponse exportRenderResponse = client2WorkRestClient.renderOnlyForTest(exportPushCommitRequest);
            log.info("exportRenderResponse: "+JSONAccessor.impl().format(exportRenderResponse));
            if (exportRenderResponse != null) {
                log.info("file > "+exportRenderResponse.getUrl());
            }
            if (exportRenderResponse==null) {
                throw new IllegalStateException("cannot render excel, file url is null");
            }
            return BaseResult.success(exportRenderResponse);
        }
        log.info("end...");
        return BaseResult.success(null);
    }




    private String write2LocalFile(String path,String nfsMeta) {
        String filePath= path
                + "/export-"+ Util.uniqueFirstPart()+".nfs";
        log.info("to write data to disk: "+filePath);
        try {
            Util.writeAtomic(new File(filePath),utf8(nfsMeta));
        } catch (IOException e) {
            throw convert2RuntimeException(e);
        }
        log.info("write data to disk ("+filePath+"), cost time ");
        return filePath;
    }


}
