package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.client.*;
import com.ovopark.iohub.sdk.model.*;
import com.ovopark.iohub.sdk.model.outstream.ExportPushStartRequest;
import com.ovopark.iohub.sdk.model.outstream.ExportPushStartResponse;
import com.ovopark.iohub.sdk.model.proto.*;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.kv.KVEngine;
import com.ovopark.module.shared.spring.rbac.SessionImpl;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.*;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

import static com.ovopark.kernel.shared.Util.*;

@JobClientActive
@Slf4j
@RestController("com.ovopark.iohub.sdk.client.outstream.ExportEndpoint")
@RequestMapping("/feign/iohub-job/processing")
public class ExportEndpoint implements InitializingBean {

    @Autowired
    private Client2ControlTransport jobClient2ControlTransport;

    private static final ExecutorService jobExecutor = new ThreadPoolExecutor(
            Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2,64)
                    , Integer.parseInt(System.getProperty("IOHUB_EXPORT_IO", "0")))
            , Math.max(Math.max(Runtime.getRuntime().availableProcessors() * 2,1024)
            , Integer.parseInt(System.getProperty("IOHUB_EXPORT_IO", "0")))
            , 600, TimeUnit.SECONDS
            //Integer.MAX_VALUE ???
            , new LinkedBlockingQueue(1)
            , newThreadFactory("iohub-export-io")
            , new ThreadPoolExecutor.AbortPolicy());

//    private static final CacheService<String, TaskSubmitRequest> C=new CacheService.MapCacheService<>(true
//            , CachedExecutors.impl("iohub-export-io-c",1,1)
//            );

    private static final KVEngine.TtlFunc<String> C=KVEngine.newTtl("iohub-export-io-c");

//    @Autowired
//    private JobTaskExecutor jobTaskExecutor;

    final private Set<Long> executingJobTaskIdSet = ConcurrentHashMap.newKeySet();

    final Map<String,SubmitTask> submitTaskMap=new ConcurrentHashMap<>();


    @Autowired
    private IOHubClientConfig ioHubClientConfig;

    @Autowired
    private JobOutTaskFlowProvider jobOutTaskFlowProvider;

    @Autowired
    private ClientNodeRegister.ClientNodeProvider clientNodeProvider;


    @RequestMapping("/submit")
    @ResponseBody
    public TaskSubmitResponse submit(@RequestBody TaskSubmitRequest taskSubmitRequest){
        final String taskKey = "task_" + taskSubmitRequest.getTaskId();
        MDC.put("traceId", taskKey);
        MDC.put("requestId", taskKey);
        log.info("receive a new task, we can do it???: "+JSONAccessor.impl().format(taskSubmitRequest));
        final TaskSubmitResponse taskSubmitResponse=new TaskSubmitResponse();
        taskSubmitResponse.setSubmitted(false);
        final JobLog jobLog = new JobLogImpl(jobClient2ControlTransport, 300, taskKey);
        try {
            lock(taskKey, new Callable<Void>() {
                @Override
                public Void call() throws Exception {
                    // same task is submit in the same node , 10min???
                    // skip the same task ??? task id + task history id
                    C.putIfAbsentAndGet(taskKey, new Function<String,TaskSubmitRequest>() {
                        @Override
                        public TaskSubmitRequest apply(String k) {

                            if (executingJobTaskIdSet.contains(taskSubmitRequest.getTaskId())) {
                                taskSubmitResponse.setSubmitted(false);
                                taskSubmitResponse.setDesc("Rejected,the previous task is executing");
                                throw new IllegalStateException("the previous task is executing, reject the task: "
                                        +JSONAccessor.impl().format(taskSubmitRequest));
                            }

                            TaskLockRequest taskLockRequest=new TaskLockRequest();
                            taskLockRequest.setTaskId(taskSubmitRequest.getTaskId());
                            taskLockRequest.setNode(ClientNode.UUID_STR);
                            TaskLockResponse taskLockResponse = jobClient2ControlTransport.lockClient(taskLockRequest);
                            if (taskLockResponse == null || !taskLockResponse.isSuccess()) {
                                throw new IllegalStateException("cannot get lock: "+ JSONAccessor.impl().format(taskLockRequest));
                            }

                            executingJobTaskIdSet.add(taskSubmitRequest.getTaskId());

                            //process pre flow ...
                            final long taskId=taskSubmitRequest.getTaskId();
                            final String uri=taskSubmitRequest.getUri();
                            final String args=taskSubmitRequest.getArgs();
                            final String session=taskSubmitRequest.getSession();
                            final boolean retry=taskSubmitRequest.isRetry();
                            final Integer exportTaskId=taskSubmitRequest.getExportTaskId();
                            final JobMeta jobMeta=taskSubmitRequest.getJobMeta();
                            final AppNode worker=taskSubmitRequest.getWorker();
                            final JobHint jobHint = taskSubmitRequest.getJobHint();
                            final JobTaskManager jobTaskManager=new JobTaskManager() {
                                @Override
                                public void cancel(long taskId) {
                                    SubmitTask submitTask = submitTaskMap.get("task_" +taskId);
                                    submitTask.future.cancel(true);
                                    log.info("cancel the task");
                                    jobLog.log("cancel the task");
                                }
                            };

                            ClientNode clientNode = clientNodeProvider.clientNode();

                            SessionImpl si = isEmpty(session)?null: JSONAccessor.impl().read(session, SessionImpl.class);
                            SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
                            factory.setReadTimeout(45_000);//ms
                            factory.setConnectTimeout(15_000);//ms
                            RestTemplate restTemplate = new RestTemplate(factory);
                            restTemplate.getMessageConverters().add(0,new StringHttpMessageConverter(StandardCharsets.UTF_8));
                            Client2WorkTransport client2WorkTransport =new Client2WorkRestClient(worker,restTemplate);

                            ExportPushStartRequest exportPushStartRequest =new ExportPushStartRequest();
                            exportPushStartRequest.setTaskId(taskId);
                            exportPushStartRequest.setApp(clientNode.app());
                            exportPushStartRequest.setClientNode(clientNode.node());
                            exportPushStartRequest.setWorkApp(worker.getApp());
                            exportPushStartRequest.setWorkNode(worker.getNode());

                            exportPushStartRequest.setExportTaskId(exportTaskId);
                            exportPushStartRequest.setJobHint(jobHint);

                            log.info("to request resource : ");
                            jobLog.log("to request resource : ");

                            ExportPushStartResponse exportPushStartResponse = client2WorkTransport.start(exportPushStartRequest);
                            if (exportPushStartResponse ==null || !exportPushStartResponse.isSuccess()) {
                                jobLog.log("cannot get enough resource , break the export task.");
                                log.info("cannot get enough resource , break the export task.");
                                taskSubmitResponse.setSubmitted(false);
                                taskSubmitResponse.setDesc("resource limit");
                                throw new IllegalStateException("resource limit, reject the task: "
                                        +JSONAccessor.impl().format(taskSubmitRequest));
                            }

                            log.info("get request resource : ");
                            jobLog.log("get request resource : ");

                            JobOutTaskFlow<RequestParamBody> jobOutTaskFlow = jobOutTaskFlowProvider.find(uri);
                            boolean taskSubmit=false;
                            try {
                                //prepared
                                jobOutTaskFlow.prepared();
                                log.info("prepare bean : ");
                                jobLog.log("prepare bean : ");
                                RequestParamBody requestParamBody=null;
                                if (retry) {
                                    requestParamBody=JSONAccessor.impl().read(args,jobOutTaskFlow.paramType());
                                }
                                else {
                                    // create export record
                                    try {
                                        requestParamBody = jobOutTaskFlow.requestParamBody(args, si);
                                    } catch (NoPrivilegeException e) {
                                        taskSubmitResponse.setSubmitted(false);
                                        taskSubmitResponse.setDesc("no privilege");
                                        throw new IllegalStateException("no privilege, reject the task: "
                                                +JSONAccessor.impl().format(taskSubmitRequest));
                                    }catch (Exception e){
                                        taskSubmitResponse.setSubmitted(false);
                                        taskSubmitResponse.setDesc(e.getMessage());
                                        log.error(e.getMessage(),e);
                                        throw new IllegalStateException("error, reject the task: "+e.getMessage()
                                                +JSONAccessor.impl().format(taskSubmitRequest));
                                    }

                                    JobOutTaskFlow.ExportTaskInfoProvider exportTaskInfoProvider = jobOutTaskFlow.exportTaskInfoProvider(requestParamBody, si);


                                    CreateExportRecordRequest createExportRecordRequest = new CreateExportRecordRequest();
                                    createExportRecordRequest.setRequestParamBody(requestParamBody);

                                    createExportRecordRequest.setExportTaskName(exportTaskInfoProvider==null?null:exportTaskInfoProvider.name());
                                    createExportRecordRequest.setTaskId(taskId);
                                    createExportRecordRequest.setApp(clientNode.app());
                                    createExportRecordRequest.setNode(clientNode.node());
                                    createExportRecordRequest.setWorkApp(worker.getApp());
                                    createExportRecordRequest.setWorkNode(worker.getNode());

                                    createExportRecordRequest.setUserId(si==null?null:si.getUserId());
                                    createExportRecordRequest.setGroupId(si==null?null:si.getGroupId());

                                    createExportRecordRequest.setJobMeta(jobMeta);

                                    CreateExportRecordResponse exportRecord = client2WorkTransport.createExportRecord(createExportRecordRequest);
                                    jobLog.log("createExportRecord: "+JSONAccessor.impl().format(exportRecord));
                                    if (exportRecord==null || !exportRecord.isSuccess() || exportRecord.getExportTaskId()==null) {
                                        jobLog.log("cannot get exportRecord id , break the export task.");
                                        log.info("cannot get exportRecord id , break the export task.");
                                        taskSubmitResponse.setSubmitted(false);
                                        taskSubmitResponse.setDesc("cannot create exportRecord");
                                        throw new IllegalStateException("cannot create exportRecord: "
                                                +JSONAccessor.impl().format(taskSubmitRequest));
                                    }
                                    log.info("created export record  , export record id: "+exportRecord.getExportTaskId());
                                    jobLog.log("created export record , export record id: "+exportRecord.getExportTaskId());
                                    taskSubmitResponse.setExportTaskId(exportRecord.getExportTaskId());
                                }
                                //query & export ???
                                OutStore outStore;
                                boolean nfs = jobMeta.isNfs();
                                if (jobHint!=null && isNotEmpty(jobHint.getOutStore())) {
                                    nfs="nfs".equalsIgnoreCase(jobHint.getOutStore()) || "nas".equalsIgnoreCase(jobHint.getOutStore());
                                }
                                if (nfs) {
                                    RowTransLogConfig rowTransLogConfig=new RowTransLogConfig();
                                    int regionRowCount=jobMeta.getRegionRowCount()>0?jobMeta.getRegionRowCount():1000;
                                    if (jobHint != null && jobHint.getRegionRowCount() > 0) {
                                        regionRowCount = jobHint.getRegionRowCount();
                                    }
                                    rowTransLogConfig.setRegionRowCount(regionRowCount);
                                    outStore=new NFSOutStore(ioHubClientConfig.nfsPath()+"/client-"+ClientNode.UUID_STR,1,rowTransLogConfig);
                                }
                                else {
                                    outStore=new InMemoryOutStore(Math.min(jobMeta.getSegmentCount(),10));
                                }
                                log.info("create out store , nfs ? : "+ nfs);
                                jobLog.log("create out store , nfs ? : "+ nfs);
                                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor
                                        =new ScheduledThreadPoolExecutor(
                                        1,newThreadFactory("tmp"),new ThreadPoolExecutor.CallerRunsPolicy());
                                scheduledThreadPoolExecutor.setKeepAliveTime(60,TimeUnit.SECONDS);
                                scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);

                                ClientNodeTaskRegisterRequest clientNodeTaskRegisterRequest=new ClientNodeTaskRegisterRequest();
                                clientNodeTaskRegisterRequest.setTaskId(taskId);
                                clientNodeTaskRegisterRequest.setApp(clientNode.app());
                                clientNodeTaskRegisterRequest.setNode(clientNode.node());
                                clientNodeTaskRegisterRequest.setWorkApp(worker.getApp());
                                clientNodeTaskRegisterRequest.setWorkNode(worker.getNode());
                                clientNodeTaskRegisterRequest.setVersion(IO.version);
                                clientNodeTaskRegisterRequest.setMinVersion(IO.minVersion);

                                RequestParamBody finalRequestParamBody=requestParamBody;
                                SubmitTask submitTask=new SubmitTask();
                                submitTask.setTaskModel(new TaskModel());
                                try {
                                    Future<?> future = jobExecutor.submit(catchRunnable(() -> {
                                        submitTask.getTaskModel().setIoThreadName(Thread.currentThread().getName());
                                        clientNodeTaskRegisterRequest.setIoThreadName(Thread.currentThread().getName());
                                        //OK , start doing real task logic
                                        final JobLog jobLog = new JobLogImpl(jobClient2ControlTransport, 300, taskKey);
                                        try {
                                            doTask(new Callable<Void>() {
                                                @Override
                                                public Void call() throws Exception {
                                                    log.info("to get all data ");
                                                    jobLog.log("to get all data ");
                                                    jobLog.flush();
                                                    try {
                                                        ((LimitLogger.LimitLoggerSetter) outStore).setLimitLogger(new LimitLogger() {
                                                            final AtomicLong limit=new AtomicLong();
                                                            @Override
                                                            public void log(String content) {
                                                                log.info(content);
                                                                if (limit.incrementAndGet()>10_000) {
                                                                    log.warn("limit logger,cannot push log to control, exceed max log count: "+10_000);
                                                                    return;
                                                                }
                                                                jobLog.log(content);
                                                            }
                                                        });
                                                        jobOutTaskFlow.execute(finalRequestParamBody,outStore);
                                                        outStore.commit();
                                                    }
                                                    catch (Throwable e){
                                                        log.error("job out task flow error: "+e.getMessage(),e);
                                                        jobLog.log("job out task flow error: "+e.getMessage());
                                                        throw convert2RuntimeException(e);
                                                    }
                                                    finally {
                                                        outStore.close();
                                                    }
                                                    log.info("got all data , then push meta to work");
                                                    jobLog.log("got all data , then push meta to work");

                                                    OutStore.Stat stat = outStore.stat();
                                                    if (isNotEmpty(stat.getSegmentStatList())) {
                                                        StringBuilder stringBuilder=new StringBuilder();
                                                        for (int i = 0; i < stat.getSegmentStatList().size(); i++) {
                                                            OutStore.SegmentStat segmentStat=stat.getSegmentStatList().get(i);
                                                            int rowCount = segmentStat.getRowCount();
                                                            stringBuilder.append(",s"+i+": "+rowCount);
                                                        }
                                                        log.info(stringBuilder.toString());
                                                        jobLog.log(stringBuilder.toString());
                                                    }
                                                    jobLog.flush();
                                                    HttpWriter httpWriter=new HttpWriter(client2WorkTransport);
                                                    httpWriter.writeAndCommit(outStore.sdList(),outStore,taskId,clientNode,worker);
                                                    log.info("task completed, and all data pushed to worker, wait worker generate xlsx???");
                                                    jobLog.log("task completed, and all data pushed to worker, wait worker generate xlsx???");
                                                    return null;
                                                }
                                            }
                                            , client2WorkTransport
                                                    ,clientNodeTaskRegisterRequest
                                                    ,scheduledThreadPoolExecutor
                                                    ,taskId,jobMeta,jobTaskManager,outStore.runtimeStat());
                                        }
                                        catch (Exception e){
                                            log.error(e.getMessage(),e);
                                            jobLog.log("error: "+e.getMessage());
                                        }
                                        finally {
                                            try {
                                                submitTaskMap.remove(taskKey);
                                            }catch (Exception e){
                                                log.error(e.getMessage(),e);
                                            }
                                            executingJobTaskIdSet.remove(taskLockRequest.getTaskId());
                                            try {
                                                jobLog.log(taskKey + " > completed: " + formatTime(LocalDateTime.now()));
                                                jobLog.flush();
                                                jobLog.close();
                                            } catch (Exception e) {
                                                log.error(e.getMessage(), e);
                                            }
                                            try {
                                                jobOutTaskFlow.close();
                                            } catch (Exception e) {
                                                log.error(e.getMessage(), e);
                                            }
                                        }
                                    }));

                                    taskSubmit=true;

                                    submitTask.setTaskId(taskSubmitRequest.getTaskId());
                                    submitTask.setFuture(future);

                                    submitTask.getTaskModel().setJobTaskId(taskSubmitRequest.getTaskId());
                                    submitTask.getTaskModel().setExportTaskId(taskSubmitRequest.getExportTaskId());
                                    submitTask.getTaskModel().setWorkNode(taskSubmitRequest.getWorker().getNode());
                                    submitTask.getTaskModel().setClientNode(ClientNode.UUID_STR);
                                    submitTask.getTaskModel().setAcceptTime(System.currentTimeMillis());
                                    submitTask.getTaskModel().setAcceptTimeStr(formatTime(LocalDateTime.now()));
                                    submitTaskMap.put(taskKey,submitTask);
                                    log.info("OK, the task is scheduled: "+taskKey);
                                    //OK ,  resource is available , executor accepts the task
                                    taskSubmitResponse.setSubmitted(true);
                                } catch (RejectedExecutionException e) {
                                    // resource is unavailable
                                    executingJobTaskIdSet.remove(taskLockRequest.getTaskId());
                                    taskSubmitResponse.setSubmitted(false);
                                    taskSubmitResponse.setDesc("Rejected, resource is unavailable ");
                                    throw convert2RuntimeException(e);
                                }

                            }
                            catch (Exception e){
                                jobLog.log("error : "+e.getMessage());
                                throw convert2RuntimeException(e);
                            }
                            finally {
                                if (!taskSubmit) {
                                    jobOutTaskFlow.close();
                                }
                                jobLog.close();
                            }
                            return taskSubmitRequest;
                        }
                    }, 60, TimeUnit.SECONDS);

                    return null;
                }
            },10,TimeUnit.SECONDS);

        }
        catch (Exception e) {
            log.error(e.getMessage(),e);
        }
        finally {
            try {
                jobLog.close();
            }
            catch (Exception e){
                log.error(e.getMessage(),e);
            }
            finally {
                MDC.remove("traceId");
                MDC.remove("requestId");
            }
        }
        return taskSubmitResponse;
    }

    @Data
    public static class SubmitTask{

        private long taskId;

        private Future<?> future;

        private TaskModel taskModel;

    }

    public interface JobTaskManager{

        void cancel(long taskId);

        default List<TaskModel> taskList(){throw new UnsupportedOperationException();}

        static JobTaskManager getOrCreate(){
            return instance;
        }

    }

    @Override
    public void afterPropertiesSet() throws Exception {
        instance=simpleJobTaskManager;
    }

    private static JobTaskManager instance;

    final private SimpleJobTaskManager simpleJobTaskManager=new SimpleJobTaskManager();

    private class SimpleJobTaskManager implements JobTaskManager{

        @Override
        public void cancel(long taskId) {
            SubmitTask submitTask = submitTaskMap.get("task_" +taskId);
            if (submitTask==null) {
                return;
            }
            if (submitTask.future==null) {
                return;
            }
            submitTask.future.cancel(true);
            log.info("cancel the task");
        }

        @Override
        public List<TaskModel> taskList() {
            List<TaskModel> taskModelList=new ArrayList<>(submitTaskMap.size());
            for (SubmitTask submitTask : submitTaskMap.values()) {
                taskModelList.add(submitTask.getTaskModel());
            }
            return taskModelList;
        }


    }


    private <T> T doTask(Callable<T> callable, Client2WorkTransport client2WorkTransport
            , ClientNodeTaskRegisterRequest clientNodeTaskRegisterRequest
            , ScheduledExecutorService taskHeartbeat
            , long taskId
            , JobMeta jobMeta
            , JobTaskManager jobTaskManager
            , OutStore.RuntimeStat runtimeStat
                         ){
        ScheduledFuture<?> scheduledFuture = taskHeartbeat.scheduleWithFixedDelay(catchRunnable(new CatchRunnable() {

            int failCount=0;

            @Override
            public void run() throws Exception {

                int sumRowCount = clientNodeTaskRegisterRequest.getSumRowCount();
                int rowCount = runtimeStat.rowCount();
                clientNodeTaskRegisterRequest.setRowCountAdded(rowCount-sumRowCount);
                clientNodeTaskRegisterRequest.setSumRowCount(rowCount);

                String currentSegment = runtimeStat.currentSegment();
                clientNodeTaskRegisterRequest.setCurrentSegment(currentSegment);
                clientNodeTaskRegisterRequest.setSegmentCount(runtimeStat.segmentCount());

                long lastIoTimeMs = runtimeStat.lastIoTimeMs();
                clientNodeTaskRegisterRequest.setLastIoTimeStr(formatTime(dateTime(lastIoTimeMs)));

                long byteSize = runtimeStat.byteSize();
                clientNodeTaskRegisterRequest.setByteSize(byteSize);

                ClientNodeTaskRegisterResponse clientNodeTaskRegisterResponse = client2WorkTransport.exportHeartbeat(clientNodeTaskRegisterRequest);
                log.info("heartbeat from work("+clientNodeTaskRegisterRequest.getWorkApp()+":"+clientNodeTaskRegisterRequest.getWorkNode()+") : "+JSONAccessor.impl().format(clientNodeTaskRegisterResponse));
                if (clientNodeTaskRegisterResponse==null || !clientNodeTaskRegisterResponse.isSuccess()) {
                    failCount++;
                    if (failCount>3) {
                        //OK , we lose connect to work... , break the task ???
                        // true , if memory , nfs ???
                        jobTaskManager.cancel(taskId);
                    }
                    return;
                }
                failCount=0;
            }
        }), 0, 5, TimeUnit.SECONDS);
        try {
            return callable.call();
        } catch (Exception e) {
            throw convert2RuntimeException(e);
        } finally {
            scheduledFuture.cancel(true);
            log.info("cancel heartbeat thread");
        }

    }


}
