package com.ovopark.iohub.sdk.client;

import com.ovopark.kernel.shared.Config;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

/**
 * @since 3.8
 */
@Slf4j
@JobClientActive
@Component
public class SpringConfigRegister implements EnvironmentAware {

    private Environment environment;

    @Override
    public void setEnvironment(Environment environment) {
        this.environment=environment;

        Config.ConfigPriority.option().takeHighPriority(new Config() {
            @Override
            public boolean contains(String key) {
                return environment.containsProperty(key);
            }

            @Override
            public Object getObject(String key, Object object) {
                String property = environment.getProperty(key);
                if (property==null) {
                    return object;
                }
                return property;
            }
        });

    }



}
