package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.client.Client2ControlTransport;
import com.ovopark.iohub.sdk.client.ClientNode;
import com.ovopark.iohub.sdk.client.ClientNodeRegister;
import com.ovopark.iohub.sdk.client.IOHubClientConfig;
import com.ovopark.iohub.sdk.model.JobHint;
import com.ovopark.iohub.sdk.model.JobMeta;
import com.ovopark.iohub.sdk.model.outstream.JobRenderStartRequest;
import com.ovopark.iohub.sdk.model.outstream.JobRenderStartResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class SpringRenderJobFactory implements RenderJobManager.RenderJobFactory, CommandLineRunner {

    @Autowired
    private ClientNodeRegister.ClientNodeProvider clientNodeProvider;

    @Autowired
    private IOHubClientConfig ioHubClientConfig;

    @Autowired
    private Client2ControlTransport client2ControlTransport;

    @Override
    public void run(String... args) throws Exception {
        RenderJobManager.register(this);
    }

    @Override
    public RenderJob factory(String uri) {
        ClientNode clientNode = clientNodeProvider.clientNode();

        JobRenderStartRequest jobRenderStartRequest=new JobRenderStartRequest();
        jobRenderStartRequest.setUri(uri);
        jobRenderStartRequest.setClientApp(clientNode.app());
        jobRenderStartRequest.setClientNode(clientNode.node());

        JobRenderStartResponse jobRenderStartResponse = client2ControlTransport.startJobRender(jobRenderStartRequest);
        if (jobRenderStartResponse==null || !jobRenderStartResponse.isSuccess() || jobRenderStartResponse.getTaskId()==null) {
            throw new IllegalArgumentException("cannot start job render: "+ JSONAccessor.impl().format(jobRenderStartResponse));
        }

        Long taskId = jobRenderStartResponse.getTaskId();
        JobMeta jobMeta = jobRenderStartResponse.getJobMeta();
        JobHint jobHint=jobRenderStartResponse.getJobHint();

        RenderJobImpl renderJob=new RenderJobImpl(taskId,uri,jobMeta.isNfs(),jobMeta,jobHint
                ,ioHubClientConfig,client2ControlTransport
                , clientNode);
        return renderJob;
    }

}
