//package com.ovopark.iohub.sdk.client;
//
//import com.ovopark.iohub.sdk.model.*;
//import com.ovopark.iohub.sdk.model.proto.NoPrivilegeException;
//import com.ovopark.kernel.shared.JSONAccessor;
//import com.ovopark.kernel.shared.Util;
//import com.ovopark.module.shared.spring.rbac.SessionImpl;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.http.client.SimpleClientHttpRequestFactory;
//import org.springframework.stereotype.Component;
//import org.springframework.web.client.RestTemplate;
//
//import java.util.concurrent.*;
//
//import static com.ovopark.kernel.shared.Util.*;
//
//@JobClientActive
//@Slf4j
//@Component
//public class SimpleJobTaskExecutor implements JobTaskExecutor{
//
//    @Autowired
//    private IOHubClientConfig ioHubClientConfig;
//
//    @Autowired
//    private JobOutTaskFlowProvider jobOutTaskFlowProvider;
//
//    @Autowired
//    private ClientNodeRegister.ClientNodeProvider clientNodeProvider;
//
//
//    @Autowired
//    private JobClient2ControlTransport jobClient2ControlTransport;
//
//
//    @Override
//    public void execute(long taskId,String uri, String args, String session, boolean retry,Integer exportTaskId
//            , JobMeta jobMeta, AppNode worker,JobLog jobLog, JobEndpoint.JobTaskManager jobTaskManager) {
//
//        ClientNode clientNode = clientNodeProvider.clientNode();
//
//        SessionImpl si = Util.isEmpty(session)?null: JSONAccessor.impl().read(session, SessionImpl.class);
//        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
//        factory.setReadTimeout(45_000);//ms
//        factory.setConnectTimeout(15_000);//ms
//        RestTemplate restTemplate = new RestTemplate(factory);
//        JobClient2WorkTransport jobClient2WorkTransport=new JobClient2WorkRestClient(worker,restTemplate);
//
//        PushStartRequest pushStartRequest=new PushStartRequest();
//        pushStartRequest.setTaskId(taskId);
//        pushStartRequest.setApp(clientNode.app());
//        pushStartRequest.setClientNode(clientNode.node());
//        pushStartRequest.setWorkApp(worker.getApp());
//        pushStartRequest.setWorkNode(worker.getNode());
//
//        pushStartRequest.setExportTaskId(exportTaskId);
//
//        log.info("to request resource : ");
//        jobLog.log("to request resource : ");
//
//        PushStartResponse pushStartResponse = jobClient2WorkTransport.start(pushStartRequest);
//        if (pushStartResponse==null || !pushStartResponse.isSuccess()) {
//            jobLog.log("cannot get enough resource , break the export task.");
//            log.info("cannot get enough resource , break the export task.");
//            PreFlowErrorRequest preFlowErrorRequest =new PreFlowErrorRequest();
//            preFlowErrorRequest.setNode(ClientNode.UUID_STR);
//            preFlowErrorRequest.setTaskId(taskId);
//            preFlowErrorRequest.setUserId(si==null?-1:si.getUserId());
//            preFlowErrorRequest.setError("resource limit, try later");
//            try {
//                log.info("resource limit , send wbs ");
//                jobClient2ControlTransport.preFlowError(preFlowErrorRequest);
//                log.info("resource limit , send wbs  , OK  ");
//            } catch (Exception ex) {
//                log.error(ex.getMessage(),ex);
//            }
//            return;
//        }
//
//        log.info("get request resource : ");
//        jobLog.log("get request resource : ");
//
//        JobOutTaskFlow<RequestParamBody> jobOutTaskFlow = jobOutTaskFlowProvider.find(uri);
//        try {
//            //prepared
//            jobOutTaskFlow.prepared();
//            log.info("prepare bean : ");
//            jobLog.log("prepare bean : ");
//            RequestParamBody requestParamBody=null;
//            if (retry) {
//                requestParamBody=JSONAccessor.impl().read(args,jobOutTaskFlow.paramType());
//            }
//            else {
//                // create export record
//                try {
//                    requestParamBody = jobOutTaskFlow.requestParamBody(args, si);
//                } catch (NoPrivilegeException e) {
//                    PreFlowErrorRequest preFlowErrorRequest =new PreFlowErrorRequest();
//                    preFlowErrorRequest.setNode(ClientNode.UUID_STR);
//                    preFlowErrorRequest.setTaskId(taskId);
//                    preFlowErrorRequest.setUserId(si==null?-1:si.getUserId());
//                    preFlowErrorRequest.setError("no privilege");
//                    try {
//                        log.info("no privilege , send wbs ");
//                        jobClient2ControlTransport.preFlowError(preFlowErrorRequest);
//                        log.info("no privilege , send wbs  , OK  ");
//                    } catch (Exception ex) {
//                        log.error(ex.getMessage(),ex);
//                    }
//                    return;
//                }
//                CreateExportRecordRequest createExportRecordRequest = new CreateExportRecordRequest();
//                createExportRecordRequest.setRequestParamBody(requestParamBody);
//
//                createExportRecordRequest.setExportTaskId(exportTaskId);
//                createExportRecordRequest.setTaskId(taskId);
//                createExportRecordRequest.setApp(clientNode.app());
//                createExportRecordRequest.setNode(clientNode.node());
//                createExportRecordRequest.setWorkApp(worker.getApp());
//                createExportRecordRequest.setWorkNode(worker.getNode());
//
//                createExportRecordRequest.setUserId(si==null?null:si.getUserId());
//                createExportRecordRequest.setGroupId(si==null?null:si.getGroupId());
//
//                createExportRecordRequest.setJobMeta(jobMeta);
//
//                CreateExportRecordResponse exportRecord = jobClient2WorkTransport.createExportRecord(createExportRecordRequest);
//                jobLog.log("createExportRecord: "+JSONAccessor.impl().format(exportRecord));
//                if (exportRecord==null || !exportRecord.isSuccess() || exportRecord.getExportTaskId()==null) {
//                    jobLog.log("cannot get exportRecord id , break the export task.");
//                    log.info("cannot get exportRecord id , break the export task.");
//                    PreFlowErrorRequest preFlowErrorRequest =new PreFlowErrorRequest();
//                    preFlowErrorRequest.setNode(ClientNode.UUID_STR);
//                    preFlowErrorRequest.setTaskId(taskId);
//                    preFlowErrorRequest.setUserId(si==null?-1:si.getUserId());
//                    preFlowErrorRequest.setError("server error");
//                    try {
//                        log.info("server error , cannot create export record , send wbs ");
//                        jobClient2ControlTransport.preFlowError(preFlowErrorRequest);
//                        log.info("server error , cannot create export record , send wbs  , OK  ");
//                    } catch (Exception ex) {
//                        log.error(ex.getMessage(),ex);
//                    }
//                    return;
//                }
//                log.info("created export record  , export record id: "+exportRecord.getExportTaskId());
//                jobLog.log("created export record , export record id: "+exportRecord.getExportTaskId());
//            }
//            //query & export ???
//            OutStore outStore;
//            if (jobMeta.isNfs()) {
//                outStore=new NFSOutStore(ioHubClientConfig.nfsPath()+"/client-"+ClientNode.UUID_STR,1);
//            }
//            else {
//                outStore=new InMemoryOutStore(Math.min(jobMeta.getSegmentCount(),10));
//            }
//            log.info("create out store , nfs ? : "+jobMeta.isNfs());
//            jobLog.log("create out store , nfs ? : "+jobMeta.isNfs());
//            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor
//                    =new ScheduledThreadPoolExecutor(
//                    1,newThreadFactory("tmp"),new ThreadPoolExecutor.CallerRunsPolicy());
//            scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
//            scheduledThreadPoolExecutor.setKeepAliveTime(60,TimeUnit.SECONDS);
//
//            ClientNodeTaskRegisterRequest clientNodeTaskRegisterRequest=new ClientNodeTaskRegisterRequest();
//            clientNodeTaskRegisterRequest.setTaskId(taskId);
//            clientNodeTaskRegisterRequest.setApp(clientNode.app());
//            clientNodeTaskRegisterRequest.setNode(clientNode.node());
//            clientNodeTaskRegisterRequest.setWorkApp(worker.getApp());
//            clientNodeTaskRegisterRequest.setWorkNode(worker.getNode());
//
//            RequestParamBody finalRequestParamBody=requestParamBody;
//            doTask(new Callable<Void>() {
//                @Override
//                public Void call() throws Exception {
//                    log.info("to get all data ");
//                    jobLog.log("to get all data ");
//                    jobLog.flush();
//                    try {
//                        jobOutTaskFlow.execute(finalRequestParamBody,outStore);
//                        outStore.commit();
//                    }
//                    catch (Exception e){
//                        throw convert2RuntimeException(e);
//                    }
//                    finally {
//                        outStore.close();
//                    }
//                    log.info("got all data , then push meta to work");
//                    jobLog.log("got all data , then push meta to work");
//                    jobLog.flush();
//                    HttpWriter httpWriter=new HttpWriter(jobClient2WorkTransport);
//                    httpWriter.writeAndCommit(outStore.sdList(),outStore,taskId,clientNode,worker);
//                    log.info("task completed, and all data pushed to worker, wait worker generate xlsx???");
//                    jobLog.log("task completed, and all data pushed to worker, wait worker generate xlsx???");
//                    return null;
//                }
//            },jobClient2WorkTransport,clientNodeTaskRegisterRequest,scheduledThreadPoolExecutor,taskId,jobMeta,jobTaskManager);
//
//        }
//        catch (Exception e){
//            jobLog.log("error : "+e.getMessage());
//            throw convert2RuntimeException(e);
//        }
//        finally {
//            jobOutTaskFlow.close();
//            jobLog.close();
//        }
//
//    }
//
//    private <T> T doTask(Callable<T> callable,JobClient2WorkTransport jobClient2WorkTransport
//            ,ClientNodeTaskRegisterRequest clientNodeTaskRegisterRequest
//            ,ScheduledExecutorService taskHeartbeat
//            ,long taskId
//            ,JobMeta jobMeta
//            , JobEndpoint.JobTaskManager jobTaskManager
//    ){
//        ScheduledFuture<?> scheduledFuture = taskHeartbeat.scheduleWithFixedDelay(catchRunnable(new Util.CatchRunnable() {
//
//            int failCount=0;
//
//            @Override
//            public void run() throws Exception {
//                ClientNodeTaskRegisterResponse clientNodeTaskRegisterResponse = jobClient2WorkTransport.heartbeat(clientNodeTaskRegisterRequest);
//                log.info("heartbeat from work("+clientNodeTaskRegisterRequest.getWorkApp()+":"+clientNodeTaskRegisterRequest.getWorkNode()+") : "+JSONAccessor.impl().format(clientNodeTaskRegisterResponse));
//                if (clientNodeTaskRegisterResponse==null || !clientNodeTaskRegisterResponse.isSuccess()) {
//                    failCount++;
//                    if (failCount>3) {
//                        //OK , we lose connect to work... , break the task ???
//                        // true , if memory , nfs ???
//                        jobTaskManager.cancel(taskId);
//                    }
//                    return;
//                }
//                failCount=0;
//            }
//        }), 0, 5, TimeUnit.SECONDS);
//        try {
//            return callable.call();
//        } catch (Exception e) {
//            throw convert2RuntimeException(e);
//        } finally {
//            scheduledFuture.cancel(true);
//            log.info("cancel heartbeat thread");
//        }
//
//    }
//
//
//}
//
//
//
