package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.client.Client2WorkTransport;
import com.ovopark.iohub.sdk.client.ClientNode;
import com.ovopark.iohub.sdk.model.AppNode;
import com.ovopark.iohub.sdk.model.outstream.ExportPushCommitRequest;
import com.ovopark.iohub.sdk.model.outstream.ExportPushCommitResponse;
import com.ovopark.iohub.sdk.model.outstream.ExportPushDataRequest;
import com.ovopark.iohub.sdk.model.outstream.ExportPushDataResponse;
import com.ovopark.iohub.sdk.model.proto.*;
import com.ovopark.iohub.sdk.model.proto.internal.*;
import com.ovopark.kernel.shared.JSONAccessor;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;

@Slf4j
public class HttpWriter implements Writer {

    final private Client2WorkTransport client2WorkTransport;

    public HttpWriter(Client2WorkTransport client2WorkTransport) {
        this.client2WorkTransport = client2WorkTransport;
    }

    @Override
    public void writeAndCommit(List<Segment.SD> sdList, OutStore outStore, long taskId, ClientNode clientNode, AppNode worker) {

        if(outStore instanceof InMemoryOutStore){
            //memory
            List<SegmentImpl> list=new ArrayList<>();
            for (Segment.SD sd : sdList) {
                Segment segment = outStore.segment(sd);
                list.add((SegmentImpl) segment);
            }

            ExportPushDataRequest exportPushDataRequest =new ExportPushDataRequest();
            exportPushDataRequest.setSegmentList(list);

            exportPushDataRequest.setTaskId(taskId);
            exportPushDataRequest.setApp(clientNode.app());
            exportPushDataRequest.setNode(clientNode.node());
            exportPushDataRequest.setWorkApp(worker.getApp());
            exportPushDataRequest.setWorkNode(worker.getNode());

            log.info("request push data checkpoint");
            ExportPushDataResponse exportPushDataResponse = client2WorkTransport.push(exportPushDataRequest);
            log.info("response push data checkpoint: "+JSONAccessor.impl().format(exportPushDataResponse));
            if(exportPushDataResponse ==null || !exportPushDataResponse.isSuccess()){
                throw new IllegalStateException("cannot push data to worker:");
            }

            ExportPushCommitRequest exportPushCommitRequest =new ExportPushCommitRequest();
            exportPushCommitRequest.setFileName(((InMemoryOutStore) outStore).getFileName());

            exportPushCommitRequest.setTaskId(taskId);
            exportPushCommitRequest.setApp(clientNode.app());
            exportPushCommitRequest.setNode(clientNode.node());
            exportPushCommitRequest.setWorkApp(worker.getApp());
            exportPushCommitRequest.setWorkNode(worker.getNode());

            exportPushCommitRequest.setGroupMap(((InMemoryOutStore) outStore).getGroupMap());
            exportPushCommitRequest.setFeature(((InMemoryOutStore) outStore).getFeature());
            log.info("request commit checkpoint");
            ExportPushCommitResponse exportPushCommitResponse = client2WorkTransport.commit(exportPushCommitRequest);
            log.info("response commit checkpoint: "+JSONAccessor.impl().format(exportPushCommitResponse));
            if(exportPushCommitResponse ==null || !exportPushCommitResponse.isSuccess()){
                throw new IllegalStateException("cannot commit data to worker:");
            }
        }

        else {
            //NFS
            List<NFSSegmentModel> nfsSegmentModelList=new ArrayList<>();
            for (Segment.SD sd : sdList) {
                NFSSegmentModel nfsSegmentModel=new NFSSegmentModel();
                nfsSegmentModel.setName(sd.getName());
                nfsSegmentModel.setUrl(sd.getUrl());
                nfsSegmentModel.setMeta(sd.getMeta());
                nfsSegmentModel.setRowCount(sd.getRowCount());
                Segment segment = outStore.segment(sd);
                nfsSegmentModel.setTitle((TitleImpl) segment.title());
                nfsSegmentModel.setHeader((HeaderImpl) segment.header());
                nfsSegmentModel.setGroup(segment.group());
                nfsSegmentModel.setFeature(segment.feature());

                nfsSegmentModelList.add(nfsSegmentModel);
            }

            ExportPushCommitRequest exportPushCommitRequest =new ExportPushCommitRequest();
            exportPushCommitRequest.setFileName(((NFSOutStore) outStore).getFileName());
            exportPushCommitRequest.setNfsSegmentModelList(nfsSegmentModelList);

            exportPushCommitRequest.setTaskId(taskId);
            exportPushCommitRequest.setApp(clientNode.app());
            exportPushCommitRequest.setNode(clientNode.node());
            exportPushCommitRequest.setWorkApp(worker.getApp());
            exportPushCommitRequest.setWorkNode(worker.getNode());

            exportPushCommitRequest.setGroupMap(((NFSOutStore) outStore).getGroupMap());
            exportPushCommitRequest.setFileIOUrl(((NFSOutStore) outStore).getFileIOUrl());
            exportPushCommitRequest.setFeature(((NFSOutStore) outStore).getFeature());

            log.info("request commit checkpoint");
            ExportPushCommitResponse exportPushCommitResponse = client2WorkTransport.commit(exportPushCommitRequest);
            log.info("response commit checkpoint: "+JSONAccessor.impl().format(exportPushCommitResponse));
            if(exportPushCommitResponse ==null || !exportPushCommitResponse.isSuccess()){
                log.error("cannot commit data to worker:"+ JSONAccessor.impl().format(exportPushCommitResponse));
                throw new IllegalStateException("cannot commit data to worker:");
            }

        }







    }
}
