package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.client.Client2ControlTransport;
import com.ovopark.iohub.sdk.client.ClientNode;
import com.ovopark.iohub.sdk.client.ClientNodeRegister;
import com.ovopark.iohub.sdk.client.IOHubClientConfig;
import com.ovopark.iohub.sdk.model.JobHint;
import com.ovopark.iohub.sdk.model.JobMeta;
import com.ovopark.iohub.sdk.model.outstream.RenderJobStartRequest;
import com.ovopark.iohub.sdk.model.outstream.RenderJobStartResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class SpringRenderJobFactory implements RenderJobManager.RenderJobFactory, CommandLineRunner {

    @Autowired
    private ClientNodeRegister.ClientNodeProvider clientNodeProvider;

    @Autowired
    private IOHubClientConfig ioHubClientConfig;

    @Autowired
    private Client2ControlTransport client2ControlTransport;

    @Override
    public void run(String... args) throws Exception {
        RenderJobManager.register(this);
    }

    @Override
    public RenderJob factory(String uri) {
        ClientNode clientNode = clientNodeProvider.clientNode();

        RenderJobStartRequest renderJobStartRequest =new RenderJobStartRequest();
        renderJobStartRequest.setUri(uri);
        renderJobStartRequest.setClientApp(clientNode.app());
        renderJobStartRequest.setClientNode(clientNode.node());

        RenderJobStartResponse renderJobStartResponse = client2ControlTransport.startRenderJob(renderJobStartRequest);
        if (renderJobStartResponse ==null || !renderJobStartResponse.isSuccess() || renderJobStartResponse.getTaskId()==null) {
            throw new IllegalArgumentException("cannot start job render: "+ JSONAccessor.impl().format(renderJobStartResponse));
        }

        Long taskId = renderJobStartResponse.getTaskId();
        JobMeta jobMeta = renderJobStartResponse.getJobMeta();
        JobHint jobHint= renderJobStartResponse.getJobHint();

        RenderJobImpl renderJob=new RenderJobImpl(taskId,uri,jobMeta.isNfs(),jobMeta,jobHint
                ,ioHubClientConfig,client2ControlTransport
                , clientNode);
        return renderJob;
    }

}
