/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.client.Client2ControlTransport;
import com.ovopark.iohub.sdk.client.ClientNode;
import com.ovopark.iohub.sdk.client.ClientNodeRegister;
import com.ovopark.iohub.sdk.client.IOHubClientConfig;
import com.ovopark.iohub.sdk.client.outstream.RenderJob;
import com.ovopark.iohub.sdk.client.outstream.RenderJobImpl;
import com.ovopark.iohub.sdk.client.outstream.RenderJobManager;
import com.ovopark.iohub.sdk.model.JobHint;
import com.ovopark.iohub.sdk.model.JobMeta;
import com.ovopark.iohub.sdk.model.outstream.RenderJobStartRequest;
import com.ovopark.iohub.sdk.model.outstream.RenderJobStartResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class SpringRenderJobFactory
implements RenderJobManager.RenderJobFactory,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(SpringRenderJobFactory.class);
    @Autowired
    private ClientNodeRegister.ClientNodeProvider clientNodeProvider;
    @Autowired
    private IOHubClientConfig ioHubClientConfig;
    @Autowired
    private Client2ControlTransport client2ControlTransport;

    public void run(String ... args) throws Exception {
        RenderJobManager.register((RenderJobManager.RenderJobFactory)this);
    }

    public RenderJob factory(String uri) {
        ClientNode clientNode = this.clientNodeProvider.clientNode();
        RenderJobStartRequest renderJobStartRequest = new RenderJobStartRequest();
        renderJobStartRequest.setUri(uri);
        renderJobStartRequest.setClientApp(clientNode.app());
        renderJobStartRequest.setClientNode(clientNode.node());
        RenderJobStartResponse renderJobStartResponse = this.client2ControlTransport.startRenderJob(renderJobStartRequest);
        if (renderJobStartResponse == null || !renderJobStartResponse.isSuccess() || renderJobStartResponse.getTaskId() == null) {
            throw new IllegalArgumentException("cannot start job render: " + JSONAccessor.impl().format((Object)renderJobStartResponse));
        }
        Long taskId = renderJobStartResponse.getTaskId();
        JobMeta jobMeta = renderJobStartResponse.getJobMeta();
        JobHint jobHint = renderJobStartResponse.getJobHint();
        RenderJobImpl renderJob = new RenderJobImpl(taskId, uri, jobMeta.isNfs(), jobMeta, jobHint, this.ioHubClientConfig, this.client2ControlTransport, clientNode);
        return renderJob;
    }
}

