package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.client.*;
import com.ovopark.iohub.sdk.model.JobHint;
import com.ovopark.iohub.sdk.model.JobMeta;
import com.ovopark.iohub.sdk.model.outstream.RenderJobStartRequest;
import com.ovopark.iohub.sdk.model.outstream.RenderJobStartResponse;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.JSONAccessor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class SpringRenderJobFactory implements RenderJobManager.RenderJobFactory, CommandLineRunner {

    /**
     * @since 4.3
     */
    final boolean renderJobTest= Config.ConfigPriority.option().getBoolean("iohub.client.renderJob.test",false);

    //test5-47.96.105.39/172.18.87.177
    final String controlIp= "47.96.105.39";
    final int controlUiPort= 13900;
    final private Client2ControlRestClient client2ControlRestClientOnlyForTest;
    {

        client2ControlRestClientOnlyForTest=new Client2ControlRestClient(new ControlNode() {
            @Override
            public String ip() {
                return controlIp;
            }

            @Override
            public int port() {
                return uiPort();
            }

            @Override
            public int uiPort() {
                return controlUiPort;
            }
        });
    }

    @Autowired
    private ClientNodeRegister.ClientNodeProvider clientNodeProvider;

    @Autowired
    private IOHubClientConfig ioHubClientConfig;

    private Client2ControlRestClient client2ControlRestClient;

    @Autowired
    public void setControlNodeProxy(ControlNodeProxy controlNodeProxy) {
        this.client2ControlRestClient = new Client2ControlRestClient(new ControlNode() {
            @Override
            public String ip() {
                return controlNodeProxy.ip();
            }

            @Override
            public int port() {
                return uiPort();
            }

            @Override
            public int uiPort() {
                return controlNodeProxy.uiPort();
            }
        });
    }

    @Override
    public void run(String... args) throws Exception {
        RenderJobManager.register(this);
    }

    @Override
    public RenderJob factory(String uri) {
        ClientNode clientNode = clientNodeProvider.clientNode();

        RenderJobStartRequest renderJobStartRequest =new RenderJobStartRequest();
        renderJobStartRequest.setUri(uri);
        renderJobStartRequest.setClientApp(clientNode.app());
        renderJobStartRequest.setClientNode(clientNode.node());

        Client2ControlRestClient client2ControlRestClientSelected=renderJobTest
                ?client2ControlRestClientOnlyForTest:client2ControlRestClient;

        RenderJobStartResponse renderJobStartResponse =
                client2ControlRestClientSelected.startRenderJob(renderJobStartRequest);
        if (renderJobStartResponse ==null || !renderJobStartResponse.isSuccess() || renderJobStartResponse.getTaskId()==null) {
            throw new IllegalArgumentException("cannot start job render: "+ JSONAccessor.impl().format(renderJobStartResponse));
        }

        Long taskId = renderJobStartResponse.getTaskId();
        JobMeta jobMeta = renderJobStartResponse.getJobMeta();
        JobHint jobHint= renderJobStartResponse.getJobHint();

        RenderJobImpl renderJob=new RenderJobImpl(taskId,uri,jobMeta.isNfs(),jobMeta,jobHint
                ,ioHubClientConfig,client2ControlRestClientSelected
                , clientNode);
        return renderJob;
    }

}
