package com.ovopark.iohub.sdk.client.instream;

import com.ovopark.iohub.sdk.client.*;
import com.ovopark.iohub.sdk.model.JobHint;
import com.ovopark.iohub.sdk.model.JobMeta;
import com.ovopark.iohub.sdk.model.instream.ReadJobStartRequest;
import com.ovopark.iohub.sdk.model.instream.ReadJobStartResponse;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.JSONAccessor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

/**
 * @since 4.6
 */
@Slf4j
@Component
public class SpringReadJobFactory implements ReadJobManager.ReadJobFactory, CommandLineRunner {

    /**
     * @since 4.3
     */
    final boolean renderJobTest= Config.ConfigPriority.option().getBoolean("iohub.client.renderJob.test",false);

    //test5-47.96.105.39/172.18.87.177
    final String controlIp= "47.96.105.39";
    final int controlUiPort= 13900;
    final private Client2ControlRestClient client2ControlRestClientOnlyForTest;
    {

        client2ControlRestClientOnlyForTest=new Client2ControlRestClient(new ControlNode() {
            @Override
            public String ip() {
                return controlIp;
            }

            @Override
            public int port() {
                return uiPort();
            }

            @Override
            public int uiPort() {
                return controlUiPort;
            }
        });
    }

    @Autowired
    private ClientNodeRegister.ClientNodeProvider clientNodeProvider;

    @Autowired
    private IOHubClientConfig ioHubClientConfig;

    private Client2ControlRestClient client2ControlRestClient;

    @Autowired
    public void setControlNodeProxy(ControlNodeProxy controlNodeProxy) {
        this.client2ControlRestClient = new Client2ControlRestClient(new ControlNode() {
            @Override
            public String ip() {
                return controlNodeProxy.ip();
            }

            @Override
            public int port() {
                return uiPort();
            }

            @Override
            public int uiPort() {
                return controlNodeProxy.uiPort();
            }
        });
    }

    @Override
    public void run(String... args) throws Exception {
        ReadJobManager.register(this);
    }

    @Override
    public ReadJob factory(String uri) {
        ClientNode clientNode = clientNodeProvider.clientNode();

        ReadJobStartRequest readJobStartRequest =new ReadJobStartRequest();
        readJobStartRequest.setUri(uri);
        readJobStartRequest.setClientApp(clientNode.app());
        readJobStartRequest.setClientNode(clientNode.node());

        Client2ControlRestClient client2ControlRestClientSelected=renderJobTest
                ?client2ControlRestClientOnlyForTest:client2ControlRestClient;

        ReadJobStartResponse readJobStartResponse =
                client2ControlRestClientSelected.startReadJob(readJobStartRequest);
        if (readJobStartResponse ==null || !readJobStartResponse.isSuccess() || readJobStartResponse.getTaskId()==null) {
            throw new IllegalArgumentException("cannot start read job: "+ JSONAccessor.impl().format(readJobStartResponse));
        }

        Long taskId = readJobStartResponse.getTaskId();
        JobMeta jobMeta = readJobStartResponse.getJobMeta();
        JobHint jobHint= readJobStartResponse.getJobHint();

        ReadJobImpl readJob=new ReadJobImpl(taskId,uri,jobMeta.isNfs(),jobMeta,jobHint
                ,ioHubClientConfig,client2ControlRestClientSelected
                , clientNode);
        return readJob;
    }

}
