package com.ovopark.iohub.sdk.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;

import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

import static com.ovopark.kernel.shared.Util.YYYY_MM_DD;
import static com.ovopark.kernel.shared.Util.YYYY_MM_DD_HH_MM_SS;

public class JacksonProviderImpl implements JSONAccessor.JSONAccessorProvider {


    @Override
    public JSONAccessor get() {

        ObjectMapper objectMapper=new ObjectMapper();
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class,new LocalDateTimeSerializer(DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS)));
        javaTimeModule.addSerializer(LocalDate.class,new LocalDateSerializer(DateTimeFormatter.ofPattern(YYYY_MM_DD)));
        javaTimeModule.addSerializer(LocalTime.class,new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDateTime.class,new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS)));
        javaTimeModule.addDeserializer(LocalDate.class,new LocalDateDeserializer(DateTimeFormatter.ofPattern(YYYY_MM_DD)));
        javaTimeModule.addDeserializer(LocalTime.class,new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        objectMapper.registerModule(javaTimeModule).registerModule(new ParameterNamesModule());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES,false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS,false);

        return new JSONAccessor() {
            @Override
            public String format(Object object) {
                try {
                    return objectMapper.writeValueAsString(object);
                } catch (JsonProcessingException e) {
                    throw Util.convert2RuntimeException(e);
                }
            }

            @Override
            public <T> T read(String text, Class<T> type) {
                try {
                    return objectMapper.readValue(text.getBytes(StandardCharsets.UTF_8),type);
                } catch (IOException e) {
                    throw Util.convert2RuntimeException(e);
                }
            }

            @Override
            public <T> T read(String text, TypeReference<T> typeReference) {
                try {
                    return objectMapper.readValue(text.getBytes(StandardCharsets.UTF_8), new com.fasterxml.jackson.core.type.TypeReference<T>() {
                        @Override
                        public Type getType() {
                            return typeReference.getType();
                        }
                    });
                } catch (IOException e) {
                    throw Util.convert2RuntimeException(e);
                }
            }

            @Override
            public Map read(String text) {
                return read(text, Map.class);
            }
        };
    }
}
