package com.ovopark.iohub.sdk.client;

import com.ovopark.kernel.shared.Config;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

@JobClientActive
@RefreshScope
@Data
@Configuration
@ConfigurationProperties("iohub.client.io")
public class IOHubClientConfigImpl implements IOHubClientConfig{


    final String nfsPath= Config.ConfigPriority.option().getString("iohub.client.io.nfsPath","/data/ovopark-iohub");

    @Override
    public String nfsPath() {
        return nfsPath;
    }
}
