package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.client.*;
import com.ovopark.iohub.sdk.model.JobHint;
import com.ovopark.iohub.sdk.model.JobMeta;
import com.ovopark.iohub.sdk.model.outstream.RenderJobStartRequest;
import com.ovopark.iohub.sdk.model.outstream.RenderJobStartResponse;
import com.ovopark.iohub.sdk.model.proto.OnlyTest;
import com.ovopark.kernel.shared.JSONAccessor;
import lombok.extern.slf4j.Slf4j;

@OnlyTest
@Slf4j
public class ConfiguredRenderJobFactory implements RenderJobManager.RenderJobFactory {

    final private ClientNodeRegister.ClientNodeProvider clientNodeProvider=new LocalClientNodeProvider();

    final private IOHubClientConfig ioHubClientConfig=new IOHubClientConfigImpl();

    final private Client2ControlRestClient client2ControlRestClient;

    final boolean renderJobTest;

    public ConfiguredRenderJobFactory(Client2ControlRestClient client2ControlRestClient,boolean renderJobTest) {
        this.client2ControlRestClient = client2ControlRestClient;
        this.renderJobTest=renderJobTest;
    }

    public ConfiguredRenderJobFactory(String ip,int uiPort) {
        this.client2ControlRestClient=new Client2ControlRestClient(new ControlNode() {
            @Override
            public String ip() {
                return ip;
            }

            @Override
            public int port() {
                return uiPort();
            }

            @Override
            public int uiPort() {
                return uiPort;
            }
        });
        this.renderJobTest=false;
    }

    @Override
    public RenderJob factory(String uri) {
        ClientNode clientNode = clientNodeProvider.clientNode();

        RenderJobStartRequest renderJobStartRequest =new RenderJobStartRequest();
        renderJobStartRequest.setUri(uri);
        renderJobStartRequest.setClientApp(clientNode.app());
        renderJobStartRequest.setClientNode(clientNode.node());

        RenderJobStartResponse renderJobStartResponse =
                client2ControlRestClient.startRenderJob(renderJobStartRequest);
        if (renderJobStartResponse ==null || !renderJobStartResponse.isSuccess() || renderJobStartResponse.getTaskId()==null) {
            throw new IllegalArgumentException("cannot start job render: "+ JSONAccessor.impl().format(renderJobStartResponse));
        }

        Long taskId = renderJobStartResponse.getTaskId();
        JobMeta jobMeta = renderJobStartResponse.getJobMeta();
        JobHint jobHint= renderJobStartResponse.getJobHint();

        RenderJobImpl renderJob=new RenderJobImpl(taskId,uri,jobMeta.isNfs(),jobMeta,jobHint
                ,ioHubClientConfig,client2ControlRestClient
                , clientNode,renderJobTest);
        return renderJob;
    }

}
