/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.client.Client2ControlTransport;
import com.ovopark.iohub.sdk.client.ClientNode;
import com.ovopark.iohub.sdk.client.JobLog;
import com.ovopark.iohub.sdk.model.TaskLogRequest;
import com.ovopark.iohub.sdk.model.TaskLogResponse;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.concurrent.ReleasableLock;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobLogImpl
implements JobLog {
    private static final Logger log = LoggerFactory.getLogger(JobLogImpl.class);
    private static final ExecutorService jobLogExecutor = new ThreadPoolExecutor(Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 16), Config.ConfigPriority.option().getInt("IOHUB_JOB_LOG_IO", Integer.valueOf(0))), Math.max(Math.max(Runtime.getRuntime().availableProcessors() * 2, 64), Config.ConfigPriority.option().getInt("IOHUB_JOB_LOG_IO", Integer.valueOf(0))), 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), Util.newThreadFactory((String)"iohub-job-log-io"), new ThreadPoolExecutor.CallerRunsPolicy());
    final Client2ControlTransport jobClient2ControlTransport;
    final Queue<String> contentQueue;
    final String traceId;
    private volatile long lastSyncLogTimeMs = System.currentTimeMillis();
    private final ReentrantReadWriteLock dataReadWriteLock = new ReentrantReadWriteLock();
    private final ReleasableLock dataSLock = new ReleasableLock((Lock)this.dataReadWriteLock.readLock());
    private final ReleasableLock dataXLock = new ReleasableLock((Lock)this.dataReadWriteLock.writeLock());
    private volatile boolean closed;

    public JobLogImpl(Client2ControlTransport jobClient2ControlTransport, int size, String traceId) {
        this.jobClient2ControlTransport = jobClient2ControlTransport;
        this.contentQueue = new ArrayBlockingQueue<String>(size);
        this.traceId = traceId;
    }

    @Override
    public void log(Supplier<String> content) {
        this.log(content.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String content) {
        if (this.closed) {
            return;
        }
        String finalContent = this.traceId + " > " + content;
        if (!this.contentQueue.offer(finalContent)) {
            this.dataXLock.acquire();
            try {
                if (this.closed) {
                    return;
                }
                long now = System.currentTimeMillis();
                if (now - this.lastSyncLogTimeMs > 1000L) {
                    ArrayList<String> list = new ArrayList<String>(this.contentQueue.size() + 1);
                    list.addAll(this.contentQueue);
                    list.add(finalContent);
                    TaskLogRequest taskLogRequest = new TaskLogRequest();
                    taskLogRequest.setLogList(list);
                    taskLogRequest.setNode(ClientNode.UUID_STR);
                    this.contentQueue.clear();
                    this.lastSyncLogTimeMs = now;
                    jobLogExecutor.execute(Util.catchRunnable(() -> {
                        TaskLogResponse taskLogResponse = this.jobClient2ControlTransport.log(taskLogRequest);
                        log.info("sync log success: " + JSONAccessor.impl().format((Object)taskLogResponse));
                    }));
                } else {
                    this.contentQueue.poll();
                    this.contentQueue.offer(finalContent);
                }
            }
            finally {
                this.dataXLock.unlock();
            }
        }
    }

    @Override
    public void flush() {
        this.fsync0(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fsync0(boolean closed) {
        this.dataXLock.acquire();
        try {
            ArrayList<String> list = new ArrayList<String>(this.contentQueue.size());
            list.addAll(this.contentQueue);
            TaskLogRequest taskLogRequest = new TaskLogRequest();
            taskLogRequest.setLogList(list);
            taskLogRequest.setNode(ClientNode.UUID_STR);
            this.contentQueue.clear();
            jobLogExecutor.execute(Util.catchRunnable(() -> {
                TaskLogResponse taskLogResponse = this.jobClient2ControlTransport.log(taskLogRequest);
                log.info("sync log success: " + JSONAccessor.impl().format((Object)taskLogResponse));
            }));
        }
        finally {
            if (closed) {
                this.closed = true;
            }
            this.dataXLock.unlock();
        }
    }

    @Override
    public void close() {
        this.fsync0(true);
    }
}

