/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.client.Client2ControlRestClient;
import com.ovopark.iohub.sdk.client.ClientNode;
import com.ovopark.iohub.sdk.client.ClientNodeRegister;
import com.ovopark.iohub.sdk.client.ControlNode;
import com.ovopark.iohub.sdk.client.IOHubClientConfig;
import com.ovopark.iohub.sdk.client.IOHubClientConfigImpl;
import com.ovopark.iohub.sdk.client.LocalClientNodeProvider;
import com.ovopark.iohub.sdk.client.outstream.RenderJob;
import com.ovopark.iohub.sdk.client.outstream.RenderJobImpl;
import com.ovopark.iohub.sdk.client.outstream.RenderJobManager;
import com.ovopark.iohub.sdk.model.JobMeta;
import com.ovopark.iohub.sdk.model.outstream.RenderJobStartRequest;
import com.ovopark.iohub.sdk.model.outstream.RenderJobStartResponse;
import com.ovopark.iohub.sdk.model.proto.OnlyTest;
import com.ovopark.iohub.sdk.model.proto.internal.JobHint;
import com.ovopark.kernel.shared.JSONAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyTest
public class ConfiguredRenderJobFactory
implements RenderJobManager.RenderJobFactory {
    private static final Logger log = LoggerFactory.getLogger(ConfiguredRenderJobFactory.class);
    private final ClientNodeRegister.ClientNodeProvider clientNodeProvider = new LocalClientNodeProvider();
    private final IOHubClientConfig ioHubClientConfig = new IOHubClientConfigImpl();
    private final Client2ControlRestClient client2ControlRestClient;
    final boolean renderJobTest;

    public ConfiguredRenderJobFactory(Client2ControlRestClient client2ControlRestClient, boolean renderJobTest) {
        this.client2ControlRestClient = client2ControlRestClient;
        this.renderJobTest = renderJobTest;
    }

    public ConfiguredRenderJobFactory(final String ip, final int uiPort) {
        this.client2ControlRestClient = new Client2ControlRestClient(new ControlNode(){

            @Override
            public String ip() {
                return ip;
            }

            @Override
            public int port() {
                return this.uiPort();
            }

            @Override
            public int uiPort() {
                return uiPort;
            }
        });
        this.renderJobTest = false;
    }

    public RenderJob factory(String uri) {
        ClientNode clientNode = this.clientNodeProvider.clientNode();
        RenderJobStartRequest renderJobStartRequest = new RenderJobStartRequest();
        renderJobStartRequest.setUri(uri);
        renderJobStartRequest.setClientApp(clientNode.app());
        renderJobStartRequest.setClientNode(clientNode.node());
        RenderJobStartResponse renderJobStartResponse = this.client2ControlRestClient.startRenderJob(renderJobStartRequest);
        if (renderJobStartResponse == null || !renderJobStartResponse.isSuccess() || renderJobStartResponse.getTaskId() == null) {
            throw new IllegalArgumentException("cannot start job render: " + JSONAccessor.impl().format((Object)renderJobStartResponse));
        }
        Long taskId = renderJobStartResponse.getTaskId();
        JobMeta jobMeta = renderJobStartResponse.getJobMeta();
        JobHint jobHint = renderJobStartResponse.getJobHint();
        RenderJobImpl renderJob = new RenderJobImpl(taskId, uri, jobMeta.isNfs(), jobMeta, jobHint, this.ioHubClientConfig, this.client2ControlRestClient, clientNode, this.renderJobTest);
        return renderJob;
    }
}

