/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client.instream;

import com.ovopark.iohub.sdk.client.Client2ControlRestClient;
import com.ovopark.iohub.sdk.client.ControlNode;
import com.ovopark.iohub.sdk.client.IOHubClientConfig;
import com.ovopark.iohub.sdk.client.IOHubClientConfigImpl;
import com.ovopark.iohub.sdk.client.LocalClientNodeProvider;
import com.ovopark.iohub.sdk.client.instream.ReadJob;
import com.ovopark.iohub.sdk.client.instream.ReadJobImpl;
import com.ovopark.iohub.sdk.client.instream.ReadJobManager;
import com.ovopark.iohub.sdk.model.JobMeta;
import com.ovopark.iohub.sdk.model.instream.ReadJobStartRequest;
import com.ovopark.iohub.sdk.model.instream.ReadJobStartResponse;
import com.ovopark.iohub.sdk.model.proto.OnlyTest;
import com.ovopark.iohub.sdk.model.proto.internal.JobHint;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.vclient.ClientNode;
import com.ovopark.kernel.shared.vclient.ClientNodeRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyTest
public class ConfiguredReadJobFactory
implements ReadJobManager.ReadJobFactory {
    private static final Logger log = LoggerFactory.getLogger(ConfiguredReadJobFactory.class);
    private final ClientNodeRegister.ClientNodeProvider clientNodeProvider = new LocalClientNodeProvider();
    private final IOHubClientConfig ioHubClientConfig = new IOHubClientConfigImpl();
    private final Client2ControlRestClient client2ControlRestClient;
    final boolean renderJobTest;

    public ConfiguredReadJobFactory(Client2ControlRestClient client2ControlRestClient, boolean renderJobTest) {
        this.client2ControlRestClient = client2ControlRestClient;
        this.renderJobTest = renderJobTest;
    }

    public ConfiguredReadJobFactory(final String ip, final int uiPort) {
        this.client2ControlRestClient = new Client2ControlRestClient(new ControlNode(){

            @Override
            public String ip() {
                return ip;
            }

            @Override
            public int port() {
                return this.uiPort();
            }

            @Override
            public int uiPort() {
                return uiPort;
            }
        });
        this.renderJobTest = false;
    }

    public ReadJob factory(String uri) {
        ClientNode clientNode = this.clientNodeProvider.clientNode();
        ReadJobStartRequest readJobStartRequest = new ReadJobStartRequest();
        readJobStartRequest.setUri(uri);
        readJobStartRequest.setClientApp(clientNode.app());
        readJobStartRequest.setClientNode(clientNode.node());
        ReadJobStartResponse readJobStartResponse = this.client2ControlRestClient.startReadJob(readJobStartRequest);
        if (readJobStartResponse == null || !readJobStartResponse.isSuccess() || readJobStartResponse.getTaskId() == null) {
            throw new IllegalArgumentException("cannot start read job: " + JSONAccessor.impl().format((Object)readJobStartResponse));
        }
        Long taskId = readJobStartResponse.getTaskId();
        JobMeta jobMeta = readJobStartResponse.getJobMeta();
        JobHint jobHint = readJobStartResponse.getJobHint();
        ReadJobImpl readJob = new ReadJobImpl(taskId, uri, jobMeta.isNfs(), jobMeta, jobHint, this.ioHubClientConfig, this.client2ControlRestClient, clientNode, this.renderJobTest);
        return readJob;
    }
}

