package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.model.*;
import com.ovopark.iohub.sdk.model.instream.ReadJobAssignWorkRequest;
import com.ovopark.iohub.sdk.model.instream.ReadJobAssignWorkResponse;
import com.ovopark.iohub.sdk.model.instream.ReadJobStartRequest;
import com.ovopark.iohub.sdk.model.instream.ReadJobStartResponse;
import com.ovopark.iohub.sdk.model.outstream.RenderJobAssignWorkRequest;
import com.ovopark.iohub.sdk.model.outstream.RenderJobAssignWorkResponse;
import com.ovopark.iohub.sdk.model.outstream.RenderJobStartRequest;
import com.ovopark.iohub.sdk.model.outstream.RenderJobStartResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobClientActive
@Slf4j
@Component
public class Client2ControlRestClientRPC implements Client2ControlTransport {


    Client2ControlRestClient client2ControlRestClient;

    @Autowired
    public void setControlNodeProxy(ControlNodeProxy controlNodeProxy) {
        this.client2ControlRestClient = new Client2ControlRestClient(controlNodeProxy);
    }


    @Override
    public ClientNodeRegisterResponse heartbeat(ClientNodeRegisterRequest clientNodeRegisterRequest) {
        return client2ControlRestClient.heartbeat(clientNodeRegisterRequest);
    }

    @Override
    public TaskLockResponse lockClient(TaskLockRequest taskLockRequest) {
        return client2ControlRestClient.lockClient(taskLockRequest);
    }

    @Override
    public TaskLogResponse log(TaskLogRequest taskLogRequest) {
        return client2ControlRestClient.log(taskLogRequest);
    }

    @Override
    public PreFlowErrorResponse preFlowError(PreFlowErrorRequest preFlowErrorRequest) {
        return client2ControlRestClient.preFlowError(preFlowErrorRequest);
    }

    @Override
    public RenderJobStartResponse startRenderJob(RenderJobStartRequest renderJobStartRequest) {
        return client2ControlRestClient.startRenderJob(renderJobStartRequest);
    }


    @Override
    public RenderJobAssignWorkResponse assignWorkRenderJob(RenderJobAssignWorkRequest renderJobAssignWorkRequest) {
        return client2ControlRestClient.assignWorkRenderJob(renderJobAssignWorkRequest);
    }

    @Override
    public ReadJobStartResponse startReadJob(ReadJobStartRequest readJobStartRequest) {
        return client2ControlRestClient.startReadJob(readJobStartRequest);
    }

    @Override
    public ReadJobAssignWorkResponse assignWorkReadJob(ReadJobAssignWorkRequest readJobAssignWorkRequest) {
        return client2ControlRestClient.assignWorkReadJob(readJobAssignWorkRequest);
    }
}
