package com.ovopark.iohub.sdk.client.instream;

import com.ovopark.iohub.sdk.client.JobClientActive;
import com.ovopark.iohub.sdk.client.outstream.RequestParamBody;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@JobClientActive
@Component
public class SpringBeanJobInTaskFlowProvider implements JobInTaskFlowProvider, ApplicationContextAware {

    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public JobInTaskFlow<RequestParamBody> find(String uri) {
        if (applicationContext.containsBean(uri)) {
            return (JobInTaskFlow<RequestParamBody>) applicationContext.getBean(uri);
        }
        return null;
    }
}
