/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.client.ClientNodeProvider;
import com.ovopark.iohub.sdk.client.ControlTransport;
import com.ovopark.iohub.sdk.client.IOHubClientConfig;
import com.ovopark.iohub.sdk.client.IOTtlCache;
import com.ovopark.iohub.sdk.client.JobClientActive;
import com.ovopark.iohub.sdk.client.instream.ImportEndpoint;
import com.ovopark.iohub.sdk.client.outstream.ExportEndpoint;
import com.ovopark.iohub.sdk.model.ClientNodeRegisterRequest;
import com.ovopark.iohub.sdk.model.ClientNodeRegisterResponse;
import com.ovopark.iohub.sdk.model.SysStat;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.vclient.ClientNode;
import com.ovopark.kernel.shared.vclient.ClientNodeRegister;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@JobClientActive
@Component(value="com.ovopark.iohub.sdk.client.ClientNodeRegisterImpl")
public class ClientNodeRegisterImpl
implements ClientNodeRegister,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ClientNodeRegisterImpl.class);
    @Autowired
    private ClientNodeProvider clientNodeProvider;
    static final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    @Autowired
    ControlTransport controlTransport;
    @Autowired
    private IOHubClientConfig ioHubClientConfig;
    final boolean verbose = Config.ConfigPriority.option().getBoolean("iohub.client.io.verbose", Boolean.valueOf(true));
    private final AtomicLong count = new AtomicLong(0L);
    static final LocalDateTime startupTime = LocalDateTime.now();

    public void register() {
        Util.schedule((ScheduledExecutorService)scheduledExecutorService, () -> {
            ClientNode clientNode = this.clientNodeProvider.clientNode();
            ClientNodeRegisterRequest clientNodeRegisterRequest = new ClientNodeRegisterRequest();
            clientNodeRegisterRequest.setStartupTime(startupTime);
            clientNodeRegisterRequest.setVersion(7);
            clientNodeRegisterRequest.setMinVersion(8);
            clientNodeRegisterRequest.setApp(clientNode.app());
            clientNodeRegisterRequest.setNode(clientNode.node());
            clientNodeRegisterRequest.setIp(clientNode.ip());
            clientNodeRegisterRequest.setPort(clientNode.port());
            clientNodeRegisterRequest.setServletPath(clientNode.servletPath());
            clientNodeRegisterRequest.setExportTaskModelList(ExportEndpoint.JobTaskManager.getOrCreate().taskList());
            clientNodeRegisterRequest.setImportTaskModelList(ImportEndpoint.JobTaskManager.getOrCreate().taskList());
            clientNodeRegisterRequest.setReceivedExportCount(ExportEndpoint.JobTaskManager.getOrCreate().receivedTaskCount());
            clientNodeRegisterRequest.setReceivedImportCount(ImportEndpoint.JobTaskManager.getOrCreate().receivedTaskCount());
            clientNodeRegisterRequest.setNfsPath(this.ioHubClientConfig.nfsPath());
            clientNodeRegisterRequest.setSysStat(SysStat.from((Util.SysStat)Util.sysStat()));
            final String nodeRootPath = this.ioHubClientConfig.nfsPath() + "/client-" + clientNode.node();
            clientNodeRegisterRequest.setNodeRootPath(nodeRootPath);
            String nfsCheckContent = (String)IOTtlCache.getOrCreate().putIfAbsentAndGet((Comparable)((Object)(ClientNode.UUID_STR + ":nfs-check")), (Function)new Function<String, String>(){

                @Override
                public String apply(String k) {
                    String nfsPath = ClientNodeRegisterImpl.this.ioHubClientConfig.nfsPath();
                    String nfsCheckContent = Util.uniqueFirstPart();
                    try {
                        File file = new File(nodeRootPath + "/nfs-check");
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        Util.writeAtomic((File)file, (byte[])Util.utf8((String)nfsCheckContent));
                    }
                    catch (IOException e) {
                        return e.getMessage();
                    }
                    return nfsCheckContent;
                }
            }, 15L, TimeUnit.SECONDS).value();
            if (this.count.getAndIncrement() % 30L == 0L) {
                IOTtlCache.getOrCreate().putAndGet((Comparable)((Object)(ClientNode.UUID_STR + ":ts")), (Function)new Function<String, String>(){

                    @Override
                    public String apply(String s) {
                        String tsTimeStr = Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]);
                        try {
                            File file = new File(nodeRootPath + "/ts");
                            if (!file.getParentFile().exists()) {
                                file.getParentFile().mkdirs();
                            }
                            Util.writeAtomic((File)file, (byte[])Util.utf8((String)tsTimeStr));
                        }
                        catch (IOException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        return tsTimeStr;
                    }
                });
            }
            clientNodeRegisterRequest.setTsFilePath(nodeRootPath + "/ts");
            clientNodeRegisterRequest.setNfsCheckContent(nfsCheckContent);
            ClientNodeRegisterResponse clientNodeRegisterResponse = this.controlTransport.heartbeat(clientNodeRegisterRequest);
            log.debug(JSONAccessor.impl().format((Object)clientNodeRegisterResponse));
        }, (long)5L, (TimeUnit)TimeUnit.SECONDS, e -> {
            if (this.verbose) {
                log.debug(e.getMessage());
            }
            return true;
        }, () -> true);
    }

    public void run(String ... args) throws Exception {
        this.register();
    }
}

