package com.ovopark.iohub.sdk.client;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

@JobClientActive
@RefreshScope
@Data
@Configuration
@ConfigurationProperties("iohub.client.node")
public class ClientNodeConfigImpl implements ClientNodeConfig {

    private String ip;

    private int port;

    private boolean useNacosIp=true;

    private String appName;

    @Override
    public String ip() {
        return ip;
    }

    @Override
    public int port() {
        return port;
    }

    @Override
    public boolean useNacosIp() {
        return useNacosIp;
    }

    @Override
    public String appName() {
        return appName;
    }
}
