package com.ovopark.iohub.sdk.client.instream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ovopark.iohub.sdk.client.*;
import com.ovopark.iohub.sdk.client.outstream.ExportEndpoint;
import com.ovopark.iohub.sdk.client.outstream.RequestParamBody;
import com.ovopark.iohub.sdk.model.*;
import com.ovopark.iohub.sdk.model.instream.*;
import com.ovopark.iohub.sdk.model.proto.*;
import com.ovopark.iohub.sdk.model.proto.internal.*;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.vclient.ClientNode;
import com.ovopark.kernel.shared.vclient.ClientNodeRegister;
import com.ovopark.module.shared.Session;
import com.ovopark.module.shared.spring.rbac.SessionImpl;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

import static com.ovopark.kernel.shared.Util.*;

@JobClientActive
@Slf4j
@RestController("com.ovopark.iohub.sdk.client.instream.ImportEndpoint")
@RequestMapping("/feign/iohub-job/processing/import")
public class ImportEndpoint implements InitializingBean {

    @Autowired
    private Client2ControlTransport client2ControlTransport;

    private static final ExecutorService jobExecutor = new ThreadPoolExecutor(
            Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2,64)
                    , Config.ConfigPriority.option().getInt("IOHUB_IMPORT_IO", 0))
            , Math.max(Math.max(Runtime.getRuntime().availableProcessors() * 2,1024)
            , Config.ConfigPriority.option().getInt("IOHUB_IMPORT_IO", 0))
            , 600, TimeUnit.SECONDS
            //Integer.MAX_VALUE ???
            , new LinkedBlockingQueue(1)
            , newThreadFactory("iohub-import-io")
            , new ThreadPoolExecutor.AbortPolicy());


//    private static final KVEngine.TtlFunc<String> C=KVEngine.newTtl("iohub-import-io-c");


    final private Set<Long> executingJobTaskIdSet = ConcurrentHashMap.newKeySet();

    final Map<String,SubmitTask> submitTaskMap=new ConcurrentHashMap<>();

    final AtomicInteger receivedTaskCount=new AtomicInteger(0);

    @Autowired
    private IOHubClientConfig ioHubClientConfig;

    @Autowired
    private JobInTaskFlowProvider jobInTaskFlowProvider;

    @Autowired
    private ClientNodeProvider clientNodeProvider;


    @RequestMapping("/submit")
    @ResponseBody
    public ImportPushDataResponse submit(@RequestBody ImportPushDataRequest importPushDataRequest){
        final String taskKey = "task_" + importPushDataRequest.getTaskId();
        MDC.put("traceId", taskKey);
        MDC.put("requestId", taskKey);
        log.info("receive a new task, we can do it???: "+JSONAccessor.impl().format(importPushDataRequest));
        final ImportPushDataResponse importPushDataResponse=new ImportPushDataResponse();
        importPushDataResponse.setSuccess(false);
        final JobLog client2ControlLog = new JobLogImpl(client2ControlTransport,  taskKey,importPushDataRequest.getTaskId());
        try {
            lock(taskKey, ()->{
                if (executingJobTaskIdSet.contains(importPushDataRequest.getTaskId())) {
                    importPushDataResponse.setSuccess(false);
                    importPushDataResponse.setDesc("Rejected,the previous task is executing");
                    throw new IllegalStateException("the previous task is executing, reject the task: "
                            +JSONAccessor.impl().format(importPushDataRequest));
                }

                TaskLockRequest taskLockRequest=new TaskLockRequest();
                taskLockRequest.setTaskId(importPushDataRequest.getTaskId());
                taskLockRequest.setNode(ClientNode.UUID_STR);
                TaskLockResponse taskLockResponse = client2ControlTransport.lockClient(taskLockRequest);
                if (taskLockResponse == null || !taskLockResponse.isSuccess()) {
                    importPushDataResponse.setSuccess(false);
                    throw new IllegalStateException("cannot get lock: "+ JSONAccessor.impl().format(taskLockRequest));
                }

                receivedTaskCount.incrementAndGet();
                executingJobTaskIdSet.add(importPushDataRequest.getTaskId());

                //process pre flow ...
                final long taskId=importPushDataRequest.getTaskId();
                final String uri=importPushDataRequest.getJobMeta().getUri();
                final String args = importPushDataRequest.getArgs();
                final ImportPreDefParam preDefParam = importPushDataRequest.getPreDefParam();
                final String session=importPushDataRequest.getSession();
                final JobMeta jobMeta=importPushDataRequest.getJobMeta();
                final AppNode worker=importPushDataRequest.getWorker();
                final JobHint jobHint = importPushDataRequest.getJobHint();
                final ImportEndpoint.JobTaskManager jobTaskManager=new JobTaskManager() {
                    @Override
                    public void cancel(long taskId) {
                        SubmitTask submitTask = submitTaskMap.get("task_" +taskId);
                        submitTask.setKilled(true);
                        submitTask.future.cancel(true);
                        logLink("cancel the task")
                                .log(log::info).log(client2ControlLog::log);
                    }
                };

                ClientNode clientNode = clientNodeProvider.clientNode();

                SessionImpl si = Util.isEmpty(session)?null: JSONAccessor.impl().read(session, SessionImpl.class);
                SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
                factory.setReadTimeout(45_000);//ms
                factory.setConnectTimeout(15_000);//ms
                RestTemplate restTemplate = new RestTemplate(factory);
                restTemplate.getMessageConverters().add(0,new StringHttpMessageConverter(StandardCharsets.UTF_8));
                Client2WorkTransport client2WorkTransport =new Client2WorkRestClient(worker,restTemplate);
                logLink("accepted , to import data??? : ").log(log::info).log(client2ControlLog::log);

                JobInTaskFlow<RequestParamBody> jobInTaskFlow = jobInTaskFlowProvider.find(
                        jobHint!=null && isNotEmpty(jobHint.getRedirectUri())?jobHint.getRedirectUri(): uri);
                boolean taskSubmit=false;
                try {
                    if (jobInTaskFlow!=null) {
                        logLink("find class: "+jobInTaskFlow.getClass().getName())
                                .log(log::info).log(client2ControlLog::log);
                    }
                    //prepared
                    jobInTaskFlow.prepared();
                    logLink("prepare bean : ").log(log::info).log(client2ControlLog::log);
                    // request param
                    RequestParamBody requestParamBody;
                    try {
                        logLink(" to parse args: "+args).log(log::info).log(client2ControlLog::log);
                        requestParamBody = isEmpty(args)?null:jobInTaskFlow.requestParamBody(args, si);
                    }
                    catch (NoPrivilegeException e) {
                        importPushDataResponse.setSuccess(false);
                        importPushDataResponse.setDesc("no privilege");
                        throw new IllegalStateException("no privilege, reject the task: "
                                +JSONAccessor.impl().format(args+", session: "+JSONAccessor.impl().format(si)));
                    }catch (Exception e){
                        client2ControlLog.flush();
                        errorStackList(e).forEach(client2ControlLog::log);
                        client2ControlLog.flush();
                        importPushDataResponse.setSuccess(false);
                        importPushDataResponse.setDesc(e.getMessage());
                        log.error(e.getMessage(),e);
                        throw new IllegalStateException("error, reject the task: "+e.getMessage()
                                +JSONAccessor.impl().format(args+", session: "+JSONAccessor.impl().format(si)));
                    }

                    JobInTaskFlow.ImportTaskInfoProvider importTaskInfoProvider = jobInTaskFlow.importTaskInfoProvider(requestParamBody,si);
                    String name = importTaskInfoProvider==null?null: importTaskInfoProvider.name();
                    Stream.from("update import record  , import record id: "+1+", pre name: "+name).subscribe(s -> {
                        log.info(s);
                        client2ControlLog.log(s);
                    });
                    //query & export ???
//                                OutStore outStore;
//                                if (jobMeta.isNfs()) {
//                                    outStore=new NFSOutStore(ioHubClientConfig.nfsPath()+"/client-"+ClientNode.UUID_STR,1);
//                                }
//                                else {
//                                    outStore=new InMemoryOutStore(Math.min(jobMeta.getSegmentCount(),10));
//                                }
//                                log.info("create out store , nfs ? : "+jobMeta.isNfs());
//                                client2ControlLog.log("create out store , nfs ? : "+jobMeta.isNfs());
                    ClientNodeTaskRegisterRequest clientNodeTaskRegisterRequest=new ClientNodeTaskRegisterRequest();
                    clientNodeTaskRegisterRequest.setTaskId(taskId);
                    clientNodeTaskRegisterRequest.setApp(clientNode.app());
                    clientNodeTaskRegisterRequest.setNode(clientNode.node());
                    clientNodeTaskRegisterRequest.setWorkApp(worker.getApp());
                    clientNodeTaskRegisterRequest.setWorkNode(worker.getNode());

                    final SubmitTask submitTask=new SubmitTask();

                    submitTask.setTaskModel(new TaskModel());
                    final TaskModel taskModel = submitTask.getTaskModel();
                    taskModel.setJobMeta(importPushDataRequest.getJobMeta());
                    taskModel.setJobHint(importPushDataRequest.getJobHint());

                    taskModel.setImportClientStat(new TaskModel.ImportClientStat());
                    final TaskModel.ImportClientStat importClientStat = taskModel.getImportClientStat();

                    final JobInTaskFlow.RuntimeStat runtimeStat=new RuntimeStatImpl();
                    try {
                        Future<?> future = jobExecutor.submit(catchRunnable(() -> {
                            submitTask.setIoThread(Thread.currentThread());
                            //OK , start doing real task logic
                            final JobLog jobLog2Control = new JobLogImpl(client2ControlTransport,taskKey,taskId);
                            taskModel.setIoThreadName(Thread.currentThread().getName());
                            taskModel.setTransientFunc(() -> {
                                int sumRowCount = importClientStat.getSumRowCount();
                                int rowCount = runtimeStat.rowCount();
                                importClientStat.setRowCountAdded(rowCount-sumRowCount);
                                importClientStat.setSumRowCount(rowCount);

                                String currentSegment = runtimeStat.currentSegment();
                                importClientStat.setCurrentSegment(currentSegment);

                            });
                            clientNodeTaskRegisterRequest.setIoThreadName(Thread.currentThread().getName());

                            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor
                                    =new ScheduledThreadPoolExecutor(
                                    1,newThreadFactory("tmp"),new ThreadPoolExecutor.CallerRunsPolicy());
                            scheduledThreadPoolExecutor.setKeepAliveTime(60,TimeUnit.SECONDS);
                            scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
                            final AtomicBoolean pushErrorFlag=new AtomicBoolean(false);
                            try {
                                doTask(()->{
                                    Stream.from("to import all data ").subscribe(s -> {
                                        log.info(s);
                                        jobLog2Control.log(s);
                                    });
                                    jobLog2Control.flush();

                                    ReplyModel replyModel=new ReplyModel();
                                    //get data stream
                                    JobInTaskFlow.DataRowStream<RequestParamBody> dataRowStream = dataRowStream0(
                                            importPushDataRequest
                                            ,requestParamBody
                                            ,jobLog2Control
                                            ,si
                                            ,submitTask
                                            ,replyModel
                                            ,runtimeStat
                                            ,jobMeta
                                    );
                                    try {
                                        //execute data stream
                                        jobInTaskFlow.execute(dataRowStream);
                                        Stream.from("import all data , then push reply to work").subscribe(s -> {
                                            log.info(s);
                                            jobLog2Control.log(s);
                                        });
                                        jobLog2Control.flush();
                                    } catch (Throwable e) {
                                        dataRowStream.mark(JobInTaskFlow.StreamProcessResult.FAIL,e.getMessage());
                                        log.error("job in task flow error: "+e.getMessage(),e);
                                        jobLog2Control.log("job in task flow error: "+e.getMessage());
                                        jobLog2Control.flush(true);
                                        errorStackList(e).forEach(jobLog2Control::log);
                                        jobLog2Control.flush(true);
                                        pushErrorFlag.set(true);
                                        throw convert2RuntimeException(e);
                                    }
                                    finally {
                                        jobLog2Control.flush();
                                        if (submitTask.killed) {
                                            throw new CancellationException("task is cancelled");
                                        }
                                        ImportReplyRequest importReplyRequest=new ImportReplyRequest();
                                        importReplyRequest.setTaskId(taskId);
                                        importReplyRequest.setApp(clientNode.app());
                                        importReplyRequest.setNode(clientNode.node());
                                        importReplyRequest.setWorkApp(worker.getApp());
                                        importReplyRequest.setWorkNode(worker.getNode());

                                        importReplyRequest.setReplyModel(replyModel);

                                        ImportReplyResponse importReplyResponse = client2WorkTransport.importReply(importReplyRequest);
                                        Stream.from("reply result: "+JSONAccessor.impl().format(importReplyResponse)).subscribe(s -> {
                                            log.info(s);
                                            jobLog2Control.log(s);
                                        });
                                        if (importReplyResponse==null|| !importReplyResponse.isSuccess()) {
                                            Stream.from("push reply fail???").subscribe(s -> {
                                                log.info(s);
                                                jobLog2Control.log(s);
                                            });
                                        }
                                        ImportCommitRequest importCommitRequest=new ImportCommitRequest();
                                        importCommitRequest.setTaskId(taskId);
                                        importCommitRequest.setApp(clientNode.app());
                                        importCommitRequest.setNode(clientNode.node());
                                        importCommitRequest.setWorkApp(worker.getApp());
                                        importCommitRequest.setWorkNode(worker.getNode());

                                        ImportCommitResponse importCommitResponse = client2WorkTransport.importCommit(importCommitRequest);
                                        Stream.from("commit result: "+JSONAccessor.impl().format(importCommitResponse)).subscribe(s -> {
                                            log.info(s);
                                            jobLog2Control.log(s);
                                        });
                                        if (importCommitResponse==null|| !importCommitResponse.isSuccess()) {
                                            Stream.from("push commit fail???").subscribe(s -> {
                                                log.info(s);
                                                jobLog2Control.log(s);
                                            });
                                        }

                                        Stream.from("task completed, and all reply pushed to worker, wait worker generate xlsx???").subscribe(s -> {
                                            log.info(s);
                                            jobLog2Control.log(s);
                                        });
                                    }
                                    return null;
                                }
                                , client2WorkTransport,clientNodeTaskRegisterRequest
                                ,scheduledThreadPoolExecutor
                                ,jobTaskManager,submitTask);
                            }
                            catch (Throwable e){
                                jobLog2Control.log("error: "+e.getMessage());
                                if (!pushErrorFlag.get()) {
                                    jobLog2Control.flush(true);
                                    errorStackList(e).forEach(jobLog2Control::log);
                                    jobLog2Control.flush(true);
                                }
                                throw convert2RuntimeException(e);
                            }
                            finally {
                                submitTaskMap.remove(taskKey);
                                executingJobTaskIdSet.remove(taskLockRequest.getTaskId());
                                try {
                                    log.info(JSONAccessor.impl().format(submitTask.getTaskModel()));
                                    jobLog2Control.log(JSONAccessor.impl().format(submitTask.getTaskModel()));
                                    jobLog2Control.log(taskKey + " > completed: " + formatTime(LocalDateTime.now()));
                                    jobLog2Control.flush();
                                    jobLog2Control.close();
                                } catch (Exception e) {
                                    log.error(e.getMessage(), e);
                                }

                                try {
                                    jobInTaskFlow.close();
                                } catch (Exception e) {
                                    log.error(e.getMessage(), e);
                                }

                            }
                        }));

                        taskSubmit=true;

                        submitTask.setTaskId(importPushDataRequest.getTaskId());
                        submitTask.setFuture(future);
                        taskModel.setJobTaskId(importPushDataRequest.getTaskId());
                        taskModel.setWorkNode(importPushDataRequest.getWorker().getNode());
                        taskModel.setClientNode(ClientNode.UUID_STR);
                        taskModel.setAcceptTime(System.currentTimeMillis());
                        taskModel.setAcceptTimeStr(formatTime(LocalDateTime.now()));

                        taskModel.setExport(false);
                        taskModel.setUri(uri);
                        taskModel.setClientApp(clientNode.app());
                        taskModel.setSession(session);
                        taskModel.setUserId(si==null?null:si.getUserId());
                        taskModel.setUserName(si==null?null:si.getUserName());
                        taskModel.setUserGroupId(si==null?null:si.getGroupId());

                        submitTaskMap.put(taskKey,submitTask);
                        log.info("OK, the task is scheduled: "+taskKey);
                        //OK ,  resource is available , executor accepts the task
                        importPushDataResponse.setSuccess(true);
                    } catch (RejectedExecutionException e) {
                        // resource is unavailable
                        executingJobTaskIdSet.remove(taskLockRequest.getTaskId());
                        importPushDataResponse.setSuccess(false);
                        importPushDataResponse.setDesc("Rejected, resource is unavailable ");
                        throw convert2RuntimeException(e);
                    }

                }
                catch (Exception e){
                    client2ControlLog.flush();
                    errorStackList(e).forEach(client2ControlLog::log);
                    client2ControlLog.flush();
                    throw convert2RuntimeException(e);
                }
                finally {
                    if (!taskSubmit) {
                        jobInTaskFlow.close();
                    }
                }
                return importPushDataRequest;
            },10,TimeUnit.SECONDS);

        }
        catch (Exception e) {
            log.error(e.getMessage(),e);
            importPushDataResponse.setSuccess(false);
            importPushDataResponse.setDesc(e.getMessage());
        }
        finally {
            try {
                client2ControlLog.close();
            }
            catch (Exception e){
                log.error(e.getMessage(),e);
            }
            finally {
                MDC.remove("traceId");
                MDC.remove("requestId");
            }
        }
        return importPushDataResponse;
    }



    private JobInTaskFlow.DataRowStream<RequestParamBody> dataRowStream0(ImportPushDataRequest importPushDataRequest
            , RequestParamBody requestParamBody
            , JobLog jobLog2Control
            , Session session
            , SubmitTask submitTask
            , ReplyModel replyModel
            , JobInTaskFlow.RuntimeStat runtimeStat
            ,JobMeta jobMeta
    ) {

        TaskModel.ImportClientStat importClientStat = submitTask.getTaskModel().getImportClientStat();
        ImportPreDefConfImpl importPreDefConf=new ImportPreDefConfImpl();
        importPreDefConf.setDataExistStrategy(importPushDataRequest.getPreDefParam().getDataExistStrategy());

        final Map<String, ReplyRowModel> replyModelIndex=new HashMap<>();
        AtomicBoolean cancelled=new AtomicBoolean(false);
        JobInTaskFlow.ImportContext importContext =new JobInTaskFlow.ImportContext() {
            @Override
            public void cancel() {
                cancelled.set(true);
            }

            @Override
            public synchronized void replyWithSegment(int segment, int fromRow, int toRow, String desc, JobInTaskFlow.Result result) {
                if (result== JobInTaskFlow.Result.EXISTS) {
                    replyModel.setRepeatCount(replyModel.getRepeatCount()+1);
                }
                else if (result== JobInTaskFlow.Result.SUCCESS) {
                    replyModel.setSuccessCount(replyModel.getSuccessCount()+1);
                }
                else if (result== JobInTaskFlow.Result.FAIL) {
                    replyModel.setErrorCount(replyModel.getErrorCount()+1);
                }
                String key=segment+":"+fromRow+":"+toRow;
                ReplyRowModel rrm = replyModelIndex.get(key);
                if (rrm==null) {
                    ReplyRowModel replyRowModel = ReplyRowModel.replyWithSegment(segment, fromRow, toRow, desc);
                    replyModel.add(replyRowModel);
                    replyModelIndex.put(key,replyRowModel);
                }
                else {
                    if (rrm.getDescList().size()>100) {
                        return;
                    }
                    rrm.getDescList().add(desc);
                }
            }
        };

        JobInTaskFlow.ImportConf<RequestParamBody> importConf=new JobInTaskFlow.ImportConf<RequestParamBody>() {
            @Override
            public RequestParamBody requestParam() {
                return requestParamBody;
            }

            @Override
            public ImportPreDefConf importPreDefConf() {
                return importPreDefConf;
            }
        };

        int maxClientLogCount = jobMeta.getMaxClientLogCount();
        LimitLogger limitLogger=new LimitLogger() {
            final AtomicLong limit=new AtomicLong();
            @Override
            public void log(String content) {
                log.info(content);
                if (limit.incrementAndGet()>maxClientLogCount) {
                    logLink("limit logger,cannot push log to control, exceed max log count: "+maxClientLogCount)
                            .log(log::info).log(jobLog2Control::log);
                    return;
                }
                jobLog2Control.log(content);
            }
        };

        final List<SegmentImpl> segmentList = importPushDataRequest.getSegmentList();
        int segmentCount = segmentList.size();
        int rowCount=0;
        for (SegmentImpl segment : segmentList) {
            rowCount+=segment.size();
        }
        int finalRowCount = rowCount;
        importClientStat.setMaxRowCount(finalRowCount);
        importClientStat.setSegmentCount(segmentList.size());
        return new JobInTaskFlow.DataRowStream<RequestParamBody>() {
            final AtomicBoolean reset=new AtomicBoolean(true);

            @Override
            public JobInTaskFlow.DataRowStream<RequestParamBody> reset() {
                reset.set(true);
                importClientStat.setResetStream(true);
                return this;
            }

            @Override
            public void mark(JobInTaskFlow.StreamProcessResult streamProcessResult, String msg) {
                if (streamProcessResult== JobInTaskFlow.StreamProcessResult.SUCCESS) {
                    replyModel.setStatus(1);
                }
                else if (streamProcessResult== JobInTaskFlow.StreamProcessResult.FAIL) {
                    replyModel.setStatus(-1);
                    replyModel.setFailMsg(msg);
                }
            }

            @Override
            public void subscribe(JobInTaskFlow.DataRowListener dataRowListener) {
                if (!reset.get()) {
                    throw new IllegalStateException("need reset stream before subscribe it.");
                }
                for (int segmentIndex = 0; segmentIndex < segmentList.size(); segmentIndex++) {
                    if (runtimeStat.cancelled()) {
                        throw new CancellationException("task is cancelled");
                    }
                    if (cancelled.get()) {
                        logLink("cancel the import flow, segment: "+segmentIndex).log(log::info).log(jobLog2Control::log);
                        reset.set(false);
                        return;
                    }
                    Segment segment=segmentList.get(segmentIndex);
                    final Map<String, Segment.Header.Cell> headerCellMap=new HashMap<>();
                    segment.header().scanUp2Down(new Segment.Header.Scan() {
                        @Override
                        public void scan(Segment.Header.Cell cell) {
                            headerCellMap.put(cell.path(),cell);
                        }
                    });
                    dataRowListener.onHeader(segmentIndex,segment.header(),importContext);
                    if (cancelled.get()) {
                        logLink("cannot pass header validation, break importing flow")
                                .log(log::info).log(jobLog2Control::log);
                        return;
                    }

                    JobInTaskFlow.HeaderLookup headerLookup=new JobInTaskFlow.HeaderLookup() {
                        @Override
                        public Segment.Header.Cell lookup(String path) {
                            return headerCellMap.get(path);
                        }
                    };
                    List<Map<String, Object>> mapList = segment.rowList();
                    int size = mapList.size();
                    for (int rowIndex = 0; rowIndex < size; rowIndex++) {
                        if (runtimeStat.cancelled()) {
                            throw new CancellationException("task is cancelled");
                        }
                        runtimeStat.rowCountAdd(1);
                        runtimeStat.currentSegment(segmentIndex+"#"+segment.name()+": "+rowIndex+"/"+size);
                        if (cancelled.get()) {
                            logLink("cancel the import flow, segment: "+segmentIndex)
                                    .log(log::info).log(jobLog2Control::log);
                            reset.set(false);
                            return;
                        }
                        Map<String, Object> data = mapList.get(rowIndex);
                        boolean allEmpty=true;
                        for (Object v : data.values()) {
                            String sv = (String) v;
                            if (sv!=null && isNotEmpty(sv.trim())) {
                                allEmpty=false;
                                break;
                            }
                        }

                        if (allEmpty) {
                            continue;
                        }


                        JobInTaskFlow.DataRowImpl dataRow=new JobInTaskFlow.DataRowImpl();
                        dataRow.setSegment(segmentIndex);
                        dataRow.setRowNum(rowIndex);
                        dataRow.setData(data);
                        dataRow.setHeaderLookup(headerLookup);
                        Map<String,List<Map<String,Object>>> processingRowData=new HashMap<>();
                        processingRowData.put(convert2String(segmentIndex+"#"+rowIndex),Arrays.asList(data));
                        submitTask.setProcessingRowData(processingRowData);
                        dataRowListener.onRow(dataRow, importContext);
                    }
                }
                reset.set(false);
            }

            @Override
            public int segmentCount() {
                return segmentCount;
            }

            @Override
            public long rowCount() {
                return finalRowCount;
            }

            @Override
            public long rowCount(int segment) {
                return segmentList.get(segment).size();
            }

            @Override
            public Session session() {
                return session;
            }

            @Override
            public JobInTaskFlow.ImportConf<RequestParamBody> importConf() {
                return importConf;
            }

            @Override
            public LimitLogger limitLogger() {
                return limitLogger;
            }
        };
    }

    @RequestMapping("/cancel")
    @ResponseBody
    public TaskCancelResponse cancel(@RequestBody TaskCancelRequest taskCancelRequest){
        TaskCancelResponse taskCancelResponse=new TaskCancelResponse();
        taskCancelResponse.setApp(clientNodeProvider.clientNode().app());
        taskCancelResponse.setNode(ClientNode.UUID_STR);

        long taskId = taskCancelRequest.getTaskId();
        if (!executingJobTaskIdSet.contains(taskId)) {
            taskCancelResponse.setFound(false);
            taskCancelResponse.setSuccess(false);
            taskCancelResponse.setDesc("cannot find task");
            return taskCancelResponse;
        }

        ImportEndpoint.SubmitTask submitTask = submitTaskMap.get("task_" +taskId);
        if (submitTask==null) {
            taskCancelResponse.setFound(false);
            taskCancelResponse.setSuccess(false);
            taskCancelResponse.setDesc("cannot find task");
            return taskCancelResponse;
        }
        // the task need be cancelled
        submitTask.setKilled(true);

        taskCancelResponse.setFound(true);
        Future<?> future = submitTask.future;
        if (future==null) {
            taskCancelResponse.setSuccess(false);
            taskCancelResponse.setDesc("cannot find io thread");
            return taskCancelResponse;
        }

        future.cancel(true);
        taskCancelResponse.setSuccess(future.isCancelled());
        taskCancelResponse.setDesc("done cancel");
        return taskCancelResponse;
    }

    @RequestMapping("/getStack")
    @ResponseBody
    public TaskStackGetResponse getStack(@RequestBody TaskStackGetRequest taskStackGetRequest){
        TaskStackGetResponse taskStackGetResponse=new TaskStackGetResponse();

        long taskId = taskStackGetRequest.getTaskId();
        if (!executingJobTaskIdSet.contains(taskId)) {
            taskStackGetResponse.setFound(false);
            taskStackGetResponse.setSuccess(false);
            taskStackGetResponse.setDesc("cannot find task");
            return taskStackGetResponse;
        }

        ImportEndpoint.SubmitTask submitTask = submitTaskMap.get("task_" +taskId);
        if (submitTask==null) {
            taskStackGetResponse.setFound(false);
            taskStackGetResponse.setSuccess(false);
            taskStackGetResponse.setDesc("cannot find task");
            return taskStackGetResponse;
        }

        Thread ioThread = submitTask.ioThread;
        if (ioThread==null) {
            taskStackGetResponse.setFound(false);
            taskStackGetResponse.setSuccess(false);
            taskStackGetResponse.setDesc("cannot find io thread");
            return taskStackGetResponse;
        }

        taskStackGetResponse.setFound(true);
        taskStackGetResponse.setSuccess(true);
        StackTraceElement[] stackTraceElements = ioThread.getStackTrace();
        List<String> statckList=new ArrayList<>(stackTraceElements.length);
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            statckList.add(stackTraceElement.toString());
        }
        taskStackGetResponse.setThread(ioThread.getName());
        taskStackGetResponse.setStackList(statckList);

        return taskStackGetResponse;
    }

    @RequestMapping("/capture")
    @ResponseBody
    public TaskCaptureResponse capture(@RequestBody TaskCaptureRequest taskCaptureRequest){

        TaskCaptureResponse taskStackGetResponse=new TaskCaptureResponse();

        long taskId = taskCaptureRequest.getTaskId();
        if (!executingJobTaskIdSet.contains(taskId)) {
            taskStackGetResponse.setFound(false);
            taskStackGetResponse.setSuccess(false);
            taskStackGetResponse.setDesc("cannot find task");
            return taskStackGetResponse;
        }

        ImportEndpoint.SubmitTask submitTask = submitTaskMap.get("task_" +taskId);
        if (submitTask==null) {
            taskStackGetResponse.setFound(false);
            taskStackGetResponse.setSuccess(false);
            taskStackGetResponse.setDesc("cannot find task");
            return taskStackGetResponse;
        }

        Thread ioThread = submitTask.ioThread;
        if (ioThread==null) {
            taskStackGetResponse.setFound(false);
            taskStackGetResponse.setSuccess(false);
            taskStackGetResponse.setDesc("cannot find io thread");
            return taskStackGetResponse;
        }

        taskStackGetResponse.setFound(true);
        taskStackGetResponse.setSuccess(true);
        taskStackGetResponse.setTaskId(taskId);
        taskStackGetResponse.setData(submitTask.getProcessingRowData());
        return taskStackGetResponse;
    }

    @Data
    public static class SubmitTask{

        private long taskId;

        private Future<?> future;

        private TaskModel taskModel;

        private boolean killed;

        @JsonIgnore
        private transient Thread ioThread;

        private Map<String,List<Map<String,Object>>> processingRowData;

    }

    public interface JobTaskManager{

        void cancel(long taskId);

        default List<TaskModel> taskList(){throw new UnsupportedOperationException();}

        static JobTaskManager getOrCreate(){
            return instance;
        }

        default int receivedTaskCount(){return 0;};

    }

    @Override
    public void afterPropertiesSet() throws Exception {
        instance=simpleJobTaskManager;
    }

    private static JobTaskManager instance;

    final private SimpleJobTaskManager simpleJobTaskManager=new SimpleJobTaskManager();

    private class SimpleJobTaskManager implements JobTaskManager{

        @Override
        public void cancel(long taskId) {
            SubmitTask submitTask = submitTaskMap.get("task_" +taskId);
            if (submitTask==null) {
                return;
            }
            submitTask.setKilled(true);
            if (submitTask.future==null) {
                return;
            }
            submitTask.future.cancel(true);
            log.info("cancel the task");
        }

        @Override
        public List<TaskModel> taskList() {
            List<TaskModel> taskModelList=new ArrayList<>(submitTaskMap.size());
            for (ImportEndpoint.SubmitTask submitTask : submitTaskMap.values()) {
                TaskModel taskModel = submitTask.getTaskModel();
                try {
                    TransientFunc transientFunc = taskModel.getTransientFunc();
                    transientFunc.run();
                }catch (Exception e){
                    log.error(e.getMessage(),e);
                }
                taskModelList.add(taskModel);
            }
            return taskModelList;
        }

        @Override
        public int receivedTaskCount() {
            return receivedTaskCount.get();
        }
    }


    private <T> T doTask(Callable<T> callable, Client2WorkTransport client2WorkTransport
            , ClientNodeTaskRegisterRequest clientNodeTaskRegisterRequest
            , ScheduledExecutorService taskHeartbeat
            , ImportEndpoint.JobTaskManager jobTaskManager
            , SubmitTask submitTask
    ){
        ScheduledFuture<?> scheduledFuture = taskHeartbeat.scheduleWithFixedDelay(catchRunnable(new CatchRunnable() {

            int failCount=0;

            @Override
            public void run() throws Exception {
                long taskId = submitTask.taskId;
                TaskModel taskModel = submitTask.getTaskModel();
                try {
                    TransientFunc transientFunc = taskModel.getTransientFunc();
                    transientFunc.run();
                }catch (Exception e){
                    log.error(e.getMessage(),e);
                }

                TaskModel.ImportClientStat importClientStat = taskModel.getImportClientStat();
                clientNodeTaskRegisterRequest.setImportClientStat(importClientStat);

                ClientNodeTaskRegisterResponse clientNodeTaskRegisterResponse = client2WorkTransport.importHeartbeat(clientNodeTaskRegisterRequest);
                log.info("heartbeat from work("+clientNodeTaskRegisterRequest.getWorkApp()+":"+clientNodeTaskRegisterRequest.getWorkNode()+") : "+JSONAccessor.impl().format(clientNodeTaskRegisterResponse));
                if (clientNodeTaskRegisterResponse==null || !clientNodeTaskRegisterResponse.isSuccess()) {
                    failCount++;
                    if (failCount>5) {
                        //OK , we lose connect to work... , break the task ???
                        // true , if memory , nfs ???
                        jobTaskManager.cancel(taskId);
                    }
                    return;
                }
                failCount=0;
            }
        }), 0, 5, TimeUnit.SECONDS);
        try {
            return callable.call();
        } catch (Exception e) {
            throw convert2RuntimeException(e);
        } finally {
            scheduledFuture.cancel(true);
            log.info("cancel heartbeat thread");
        }

    }


    static class RuntimeStatImpl implements JobInTaskFlow.RuntimeStat {

        final private AtomicInteger rowCount=new AtomicInteger(0);

        String segment;

        private volatile boolean cancelled;

        @Override
        public void rowCountAdd(int added) {
            rowCount.addAndGet(added);
        }

        @Override
        public int rowCount() {
            return rowCount.get();
        }

        @Override
        public void currentSegment(String segment) {
            this.segment=segment;
        }

        @Override
        public String currentSegment() {
            return segment;
        }

        @Override
        public void cancel() {
            this.cancelled=true;
        }

        @Override
        public boolean cancelled() {
            return cancelled;
        }
    }

}
