package com.ovopark.iohub.sdk.client;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;


@IOHubClientActive
@RefreshScope
@Data
@Configuration
@ConfigurationProperties("iohub.client.control")
public class ControlNodeImpl implements ControlNode{

    private String ip="127.0.0.1";

    private int port=13910;

    private int uiPort=13900;

    @Override
    public String ip() {
        return ip;
    }

    @Override
    public int port() {
        return port;
    }

    @Override
    public int uiPort() {
        return uiPort;
    }
}
