package com.ovopark.iohub.sdk.client;

import com.ovopark.kernel.shared.Config;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import static com.ovopark.kernel.shared.Util.newThreadFactory;

public interface JobLog extends com.ovopark.kernel.shared.vclient.JobLog {

    ExecutorService jobLogExecutor = new ThreadPoolExecutor(
            Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2,16)
                    , Config.ConfigPriority.option().getInt("IOHUB_JOB_LOG_IO", 0))
            , Math.max(Math.max(Runtime.getRuntime().availableProcessors() * 2,64)
            , Config.ConfigPriority.option().getInt("IOHUB_JOB_LOG_IO", 0))
            , 600, TimeUnit.SECONDS
            //Integer.MAX_VALUE ???
            , new LinkedBlockingQueue(1)
            , newThreadFactory("iohub-job-log-io")
            , new ThreadPoolExecutor.CallerRunsPolicy());



}
