/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.client.ClientNodeConfig;
import com.ovopark.iohub.sdk.client.ClientNodeProvider;
import com.ovopark.iohub.sdk.client.IOHubClientActive;
import com.ovopark.kernel.shared.NetUtil;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.vclient.ClientNode;
import java.net.InetAddress;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.stereotype.Component;

@IOHubClientActive
@Component(value="com.ovopark.iohub.sdk.client.NacosNodeProvider")
public class NacosNodeProvider
implements ClientNodeProvider {
    @Autowired
    private ServiceInstance serviceInstance;
    @Autowired
    private ClientNodeConfig clientNodeConfig;
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;
    @Value(value="${spring.application.name}")
    private String app;

    public ClientNode clientNode() {
        URI uri = this.serviceInstance.getUri();
        String registerIp = this.clientNodeConfig.ip();
        if (Util.isEmpty((CharSequence)registerIp)) {
            if (this.clientNodeConfig.useNacosIp()) {
                registerIp = uri.getHost();
            } else {
                InetAddress localAddress = NetUtil.getLocalAddress();
                registerIp = localAddress.getHostAddress();
            }
        }
        if (Util.isEmpty((CharSequence)registerIp)) {
            Util.log.error("cannot find right IP , exit JVM.");
            return null;
        }
        int port = this.clientNodeConfig.port() > 0 ? this.clientNodeConfig.port() : uri.getPort();
        if (port <= 0) {
            Util.log.error("cannot find port , exit JVM.");
            return null;
        }
        ClientNode.ClientNodeImpl node = new ClientNode.ClientNodeImpl();
        node.setNode(ClientNode.UUID_STR);
        node.setIp(registerIp);
        node.setPort(port);
        node.setServletPath(this.contextPath);
        node.setApp(this.app);
        return node;
    }
}

