package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.client.IOHubClientActive;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@IOHubClientActive
@Component
public class SpringBeanJobOutTaskFlowProvider implements JobOutTaskFlowProvider, ApplicationContextAware {

    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public JobOutTaskFlow<RequestParamBody> find(String uri) {
        return (JobOutTaskFlow<RequestParamBody>) applicationContext.getBean(uri);
    }
}
