/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.iohub.sdk.model.proto.CellDataType;
import com.ovopark.iohub.sdk.model.proto.CellDef;
import com.ovopark.iohub.sdk.model.proto.CellIgnore;
import com.ovopark.iohub.sdk.model.proto.HeaderCellImpl;
import com.ovopark.iohub.sdk.model.proto.HeaderDef;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class HeaderImpl
implements Segment.Header,
Model {
    private boolean committed;
    private boolean fixed;
    private final List<HeaderCellImpl> cellList = new ArrayList<HeaderCellImpl>();
    private int height;
    private int defaultColumnWidth = 15;
    private int maxHeadIndex;

    @Override
    public int maxHeadIndex() {
        return this.maxHeadIndex;
    }

    @Override
    public void root(String property) {
        if (this.committed) {
            throw new IllegalArgumentException("header was fixed, cannot modify");
        }
        this.upset(null, property, null, null);
    }

    @Override
    public void root(List<String> propertyList) {
        if (this.committed) {
            throw new IllegalArgumentException("header was fixed, cannot modify");
        }
        propertyList.forEach(this::root);
    }

    @Override
    public void i18n(Segment.Header.I18n i18n) {
        this.func(i18n::i18n, this.cellList, (s, cell) -> cell.setName((String)s));
    }

    @Override
    public void width(Segment.Header.Width width) {
        this.func(width::width, this.cellList, (s, cell) -> cell.setWidth((int)s));
    }

    private <R> void func(Function<String, R> func, List<HeaderCellImpl> cellList, CellFuncSet<R> cellFuncSet) {
        for (HeaderCellImpl cell : cellList) {
            R apply = func.apply(cell.getPath());
            cellFuncSet.set(apply, cell);
            if (!Util.isNotEmpty(cell.getCellList())) continue;
            this.func(func, cell.getCellList(), cellFuncSet);
        }
    }

    @Override
    public void children(String path, List<String> propertyList) {
        for (String p : propertyList) {
            this.upset(path, p, null, null);
        }
    }

    @Override
    public void children(String path, String property) {
        this.children(path, property, null);
    }

    @Override
    public void children(String path, String property, Segment.Header.Width width) {
        this.children(path, property, width, null);
    }

    @Override
    public void children(String path, String property, Segment.Header.Width width, Segment.Header.I18n i18n) {
        this.children(path, property, width, i18n, null);
    }

    @Override
    public void children(String path, String property, Segment.Header.Width width, Segment.Header.I18n i18n, Segment.Header.CellType cellType) {
        this.upset(path, property, width, i18n, cellType);
    }

    @Override
    public void upset(String path, String property, Segment.Header.Width width) {
        this.upset(path, property, width, null);
    }

    @Override
    public void upset(String path, String property, Segment.Header.Width width, Segment.Header.I18n i18n) {
        this.upset(path, property, width, i18n, null);
    }

    @Override
    public void upset(String path, String property, Segment.Header.Width width, Segment.Header.I18n i18n, Segment.Header.CellType cellType) {
        if (this.committed) {
            throw new IllegalArgumentException("header was fixed, cannot modify");
        }
        if (Util.isEmpty((CharSequence)path)) {
            HeaderCellImpl cell = new HeaderCellImpl();
            cell.setProperty(property);
            cell.setLevel(0);
            cell.setPath(property);
            if (width != null) {
                cell.setWidth(width.width(property));
            }
            if (i18n != null) {
                cell.setName(i18n.i18n(property));
            }
            if (cellType != null) {
                cell.setCellType(cellType.cellType(property));
            }
            this.cellList.add(cell);
            return;
        }
        HeaderCellImpl pathCell = null;
        List<HeaderCellImpl> queryCellList = this.cellList;
        String[] pl = path.split("\\.");
        for (int i = 0; i < pl.length; ++i) {
            String p = pl[i];
            HeaderCellImpl next = null;
            for (HeaderCellImpl cell : queryCellList) {
                if (!cell.getProperty().equals(p)) continue;
                next = cell;
                break;
            }
            if (next == null) {
                throw new IllegalArgumentException("sub path: '" + p + "' is missing? " + path);
            }
            queryCellList = next.getCellList();
            pathCell = next;
        }
        if (pathCell == null) {
            throw new IllegalArgumentException("path is missing: " + path);
        }
        List<HeaderCellImpl> cellList = pathCell.getCellList();
        if (cellList == null) {
            cellList = new ArrayList<HeaderCellImpl>();
        }
        HeaderCellImpl cell = new HeaderCellImpl();
        cell.setProperty(property);
        cell.setPath(path + "." + property);
        cell.setLevel(pl.length);
        if (width != null) {
            cell.setWidth(width.width(cell.getPath()));
        }
        if (i18n != null) {
            cell.setName(i18n.i18n(cell.getPath()));
        }
        if (cellType != null) {
            cell.setCellType(cellType.cellType(cell.getPath()));
        }
        this.height = Math.max(this.height, cell.getLevel());
        cellList.add(cell);
        pathCell.setCellList(cellList);
    }

    @Override
    public void defaultColumnWidth(int width) {
        this.defaultColumnWidth = width;
    }

    @Override
    public int defaultColumnWidth() {
        return this.defaultColumnWidth;
    }

    @Override
    public void all(Class<? extends Model> clazz) {
        boolean javaTypeAsDataType = true;
        HeaderDef headerDef = clazz.getDeclaredAnnotation(HeaderDef.class);
        if (headerDef != null) {
            this.setDefaultColumnWidth(headerDef.defaultColumnWidth() > 0 ? headerDef.defaultColumnWidth() : 15);
            if (headerDef.fixed()) {
                this.fixed();
            }
            javaTypeAsDataType = headerDef.javaTypeAsDataType();
        }
        final boolean javaTypeAsDataTypeDef = javaTypeAsDataType;
        Map fieldMap = Util.flatProperty(clazz, field -> field.getDeclaredAnnotation(CellIgnore.class) == null);
        for (Map.Entry entry : fieldMap.entrySet()) {
            String c = (String)entry.getKey();
            String parentPath = c.substring(0, Math.max(c.lastIndexOf("."), 0));
            String subPath = c.substring(Math.max(c.lastIndexOf(".") + 1, 0));
            final Field field2 = (Field)entry.getValue();
            final CellDef cellDef = field2.getDeclaredAnnotation(CellDef.class);
            this.upset(parentPath, subPath, new Segment.Header.Width(){

                @Override
                public int width(String path) {
                    return cellDef == null ? 0 : cellDef.width();
                }
            }, null, new Segment.Header.CellType(){

                @Override
                public CellDataType cellType(String path) {
                    CellDataType def;
                    CellDataType cellDataType = def = cellDef == null ? CellDataType.NONE : cellDef.cellDataType();
                    if (def == CellDataType.NONE && javaTypeAsDataTypeDef) {
                        Class<?> type = field2.getType();
                        def = Boolean.class.isAssignableFrom(type) || Boolean.TYPE == type ? CellDataType.BOOLEAN : (Number.class.isAssignableFrom(type) || Integer.TYPE == type || Long.TYPE == type || Short.TYPE == type || Byte.TYPE == type || Float.TYPE == type || Double.TYPE == type ? CellDataType.NUMERIC : CellDataType.STRING);
                    }
                    return def;
                }
            });
        }
    }

    @Override
    public void fixed() {
        this.fixed = true;
    }

    @Override
    public void commit() {
        if (this.committed) {
            return;
        }
        this.committed = true;
        for (HeaderCellImpl cell : this.cellList) {
            int i = cell.calLeafCount();
            cell.setLeafCount(i);
        }
        for (int i = 0; i < this.cellList.size(); ++i) {
            HeaderCellImpl cell;
            cell = this.cellList.get(i);
            if (i == 0) {
                cell.calPosition(0);
                continue;
            }
            HeaderCellImpl b = this.cellList.get(i - 1);
            cell.calPosition(b.getPosition() + b.leafCount());
        }
        this.scanUp2Down(new Segment.Header.Scan(){

            @Override
            public void scan(Segment.Header.Cell cell) {
                HeaderImpl.this.maxHeadIndex = Math.max(HeaderImpl.this.maxHeadIndex, cell.position());
            }
        });
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public void scanUp2Down(Segment.Header.Scan scan) {
        this.scanUp2Down0(scan, this.cellList);
    }

    private void scanUp2Down0(Segment.Header.Scan scan, List<HeaderCellImpl> cellList) {
        ArrayList<HeaderCellImpl> nextList = new ArrayList<HeaderCellImpl>();
        for (HeaderCellImpl cell : cellList) {
            scan.scan(cell);
            if (!Util.isNotEmpty(cell.getCellList())) continue;
            nextList.addAll(cell.getCellList());
        }
        if (Util.isNotEmpty(nextList)) {
            this.scanUp2Down0(scan, nextList);
        }
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public List<HeaderCellImpl> getCellList() {
        return this.cellList;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDefaultColumnWidth() {
        return this.defaultColumnWidth;
    }

    public int getMaxHeadIndex() {
        return this.maxHeadIndex;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setDefaultColumnWidth(int defaultColumnWidth) {
        this.defaultColumnWidth = defaultColumnWidth;
    }

    public void setMaxHeadIndex(int maxHeadIndex) {
        this.maxHeadIndex = maxHeadIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeaderImpl)) {
            return false;
        }
        HeaderImpl other = (HeaderImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCommitted() != other.isCommitted()) {
            return false;
        }
        if (this.isFixed() != other.isFixed()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.getDefaultColumnWidth() != other.getDefaultColumnWidth()) {
            return false;
        }
        if (this.getMaxHeadIndex() != other.getMaxHeadIndex()) {
            return false;
        }
        List<HeaderCellImpl> this$cellList = this.getCellList();
        List<HeaderCellImpl> other$cellList = other.getCellList();
        return !(this$cellList == null ? other$cellList != null : !((Object)this$cellList).equals(other$cellList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HeaderImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCommitted() ? 79 : 97);
        result = result * 59 + (this.isFixed() ? 79 : 97);
        result = result * 59 + this.getHeight();
        result = result * 59 + this.getDefaultColumnWidth();
        result = result * 59 + this.getMaxHeadIndex();
        List<HeaderCellImpl> $cellList = this.getCellList();
        result = result * 59 + ($cellList == null ? 43 : ((Object)$cellList).hashCode());
        return result;
    }

    public String toString() {
        return "HeaderImpl(committed=" + this.isCommitted() + ", fixed=" + this.isFixed() + ", cellList=" + this.getCellList() + ", height=" + this.getHeight() + ", defaultColumnWidth=" + this.getDefaultColumnWidth() + ", maxHeadIndex=" + this.getMaxHeadIndex() + ")";
    }

    static interface CellFuncSet<R> {
        public void set(R var1, HeaderCellImpl var2);
    }
}

