/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.iohub.sdk.model.proto.HeaderImpl;
import com.ovopark.iohub.sdk.model.proto.MixedRowTransLogImpl;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.iohub.sdk.model.proto.RowTransLog;
import com.ovopark.iohub.sdk.model.proto.RowTransLogConfig;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NFSOutStore
implements OutStore {
    private String fileName;
    private final String path;
    private final List<SegmentFileDescriptor> segmentFileDescriptorList;
    private boolean committed;
    private final List<SegmentFileWriter> segmentFileWriterList = new ArrayList<SegmentFileWriter>();

    public NFSOutStore(String path, int size) {
        this.path = path + "/" + Util.uniqueFirstPart();
        File file = new File(this.path);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.segmentFileDescriptorList = new ArrayList<SegmentFileDescriptor>(size);
    }

    @Override
    public OutStore.SegmentWriter createSegment(String name) {
        return this.createSegment(name, 1);
    }

    @Override
    public OutStore.SegmentWriter createSegment(String name, int rowSize) {
        return this.createSegment(name, rowSize, "default");
    }

    @Override
    public OutStore.SegmentWriter createSegment(String name, String group) {
        return this.createSegment(name, 1, group);
    }

    @Override
    public OutStore.SegmentWriter createSegment(String name, int rowSize, String group) {
        this.check();
        SegmentFileWriter segmentFileWriter = new SegmentFileWriter(name, group, rowSize);
        this.segmentFileWriterList.add(segmentFileWriter);
        return segmentFileWriter;
    }

    @Override
    public void commit() {
        this.committed = true;
    }

    @Override
    public void close() {
        Exception exception = null;
        for (SegmentFileWriter segmentFileWriter : this.segmentFileWriterList) {
            try {
                segmentFileWriter.close();
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw Util.convert2RuntimeException(exception);
        }
    }

    private void check() {
        if (this.committed) {
            throw new UnsupportedOperationException("all committed???");
        }
    }

    @Override
    public Segment segment(Segment.SD sd) {
        for (final SegmentFileDescriptor segmentFileDescriptor : this.segmentFileDescriptorList) {
            if (!segmentFileDescriptor.getName().equals(sd.getName())) continue;
            return new Segment(){

                @Override
                public List<Map<String, Object>> rowList() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int size() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void append(Map<String, Object> row) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String name() {
                    return segmentFileDescriptor.getName();
                }

                @Override
                public Map<String, Object> meta() {
                    return segmentFileDescriptor.getMeta();
                }

                @Override
                public Segment.Header header() {
                    return segmentFileDescriptor.header;
                }

                @Override
                public String group() {
                    return segmentFileDescriptor.getGroup();
                }

                @Override
                public void commit() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }

    @Override
    public List<Segment.SD> sdList() {
        ArrayList<Segment.SD> sdList = new ArrayList<Segment.SD>(this.segmentFileDescriptorList.size());
        for (SegmentFileDescriptor segmentFileDescriptor : this.segmentFileDescriptorList) {
            Segment.SD sd = new Segment.SD();
            sd.setName(segmentFileDescriptor.getName());
            sd.setMemory(false);
            sd.setUrl(segmentFileDescriptor.getPath());
            sd.setRowCount(segmentFileDescriptor.getRowCount());
            sdList.add(sd);
        }
        return sdList;
    }

    @Override
    public void fileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPath() {
        return this.path;
    }

    class SegmentFileWriter
    implements OutStore.SegmentWriter {
        private final String name;
        private final String group;
        private final RowTransLog rowTransLog;
        final String filePath;
        private final Segment.Header header = new HeaderImpl();
        private Map<String, Object> meta;
        private int rowCount;

        public SegmentFileWriter(String name, String group, int size) {
            this.name = name;
            this.group = group;
            RowTransLogConfig rowTransLogConfig = new RowTransLogConfig();
            rowTransLogConfig.setWalBufferSizeMb(10);
            rowTransLogConfig.setWalDiskSizeMb(1024L);
            rowTransLogConfig.setWalIntervalSec(1);
            this.filePath = NFSOutStore.this.path + "/" + Util.md5((String)name);
            this.rowTransLog = new MixedRowTransLogImpl("segment", this.filePath, rowTransLogConfig);
        }

        @Override
        public void append(Map<String, Object> data) {
            this.rowTransLog.append(data);
            ++this.rowCount;
        }

        @Override
        public void append(List<Map<String, Object>> data) {
            this.rowTransLog.append(data);
            this.rowCount += data.size();
        }

        @Override
        public void append(Model model) {
            this.append(JSONAccessor.impl().read(JSONAccessor.impl().format((Object)model)));
        }

        @Override
        public void meta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Override
        public void commit() {
            this.rowTransLog.fsync();
            SegmentFileDescriptor segmentFileDescriptor = new SegmentFileDescriptor();
            segmentFileDescriptor.setPath(this.filePath);
            segmentFileDescriptor.setName(this.name);
            segmentFileDescriptor.setHeader(this.header);
            segmentFileDescriptor.setMeta(this.meta);
            segmentFileDescriptor.setGroup(this.group);
            segmentFileDescriptor.setRowCount(this.rowCount);
            NFSOutStore.this.segmentFileDescriptorList.add(segmentFileDescriptor);
            this.header().commit();
        }

        @Override
        public Segment.Header header() {
            return this.header;
        }

        void close() throws Exception {
            this.rowTransLog.close();
        }
    }

    static class SegmentFileDescriptor
    implements Model {
        private String path;
        private String name;
        private Segment.Header header;
        private Map<String, Object> meta;
        private String group;
        private int rowCount;

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public Segment.Header getHeader() {
            return this.header;
        }

        public Map<String, Object> getMeta() {
            return this.meta;
        }

        public String getGroup() {
            return this.group;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setHeader(Segment.Header header) {
            this.header = header;
        }

        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public void setRowCount(int rowCount) {
            this.rowCount = rowCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentFileDescriptor)) {
                return false;
            }
            SegmentFileDescriptor other = (SegmentFileDescriptor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRowCount() != other.getRowCount()) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Segment.Header this$header = this.getHeader();
            Segment.Header other$header = other.getHeader();
            if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            return !(this$group == null ? other$group != null : !this$group.equals(other$group));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SegmentFileDescriptor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRowCount();
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Segment.Header $header = this.getHeader();
            result = result * 59 + ($header == null ? 43 : $header.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            return result;
        }

        public String toString() {
            return "NFSOutStore.SegmentFileDescriptor(path=" + this.getPath() + ", name=" + this.getName() + ", header=" + this.getHeader() + ", meta=" + this.getMeta() + ", group=" + this.getGroup() + ", rowCount=" + this.getRowCount() + ")";
        }
    }
}

