/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.iohub.sdk.model.proto.CellDataType;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.Util;
import java.util.Arrays;
import java.util.List;

public class HeaderCellImpl
implements Segment.Header.Cell {
    private int level;
    private String path;
    private String property;
    private String name;
    private List<HeaderCellImpl> cellList;
    private int leafCount;
    private int position;
    private int width;
    private CellDataType cellType;
    private String[] pathLink;

    @Override
    public String[] pathLink() {
        if (this.pathLink == null) {
            this.pathLink = this.path.split("\\.");
        }
        return this.pathLink;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public CellDataType cellType() {
        return this.cellType;
    }

    public int calLeafCount() {
        if (Util.isEmpty(this.cellList)) {
            this.leafCount = 1;
            return 1;
        }
        int sum = 0;
        for (HeaderCellImpl cell : this.cellList) {
            int i = cell.calLeafCount();
            sum += i;
        }
        this.leafCount = sum;
        return sum;
    }

    void calPosition(int position) {
        this.setPosition(position);
        if (Util.isEmpty(this.cellList)) {
            return;
        }
        for (int i = 0; i < this.cellList.size(); ++i) {
            HeaderCellImpl cell = this.cellList.get(i);
            if (i == 0) {
                cell.calPosition(position);
                continue;
            }
            HeaderCellImpl b = this.cellList.get(i - 1);
            cell.calPosition(b.getPosition() + b.leafCount());
        }
    }

    @Override
    public int level() {
        return this.getLevel();
    }

    @Override
    public String path() {
        return this.getPath();
    }

    @Override
    public String property() {
        return this.getProperty();
    }

    @Override
    public String name() {
        return this.getName();
    }

    @Override
    public List<? extends Segment.Header.Cell> cellList() {
        return this.getCellList();
    }

    @Override
    public int leafCount() {
        return this.getLeafCount();
    }

    public int getLevel() {
        return this.level;
    }

    public String getPath() {
        return this.path;
    }

    public String getProperty() {
        return this.property;
    }

    public String getName() {
        return this.name;
    }

    public List<HeaderCellImpl> getCellList() {
        return this.cellList;
    }

    public int getLeafCount() {
        return this.leafCount;
    }

    public int getPosition() {
        return this.position;
    }

    public int getWidth() {
        return this.width;
    }

    public CellDataType getCellType() {
        return this.cellType;
    }

    public String[] getPathLink() {
        return this.pathLink;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCellList(List<HeaderCellImpl> cellList) {
        this.cellList = cellList;
    }

    public void setLeafCount(int leafCount) {
        this.leafCount = leafCount;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setCellType(CellDataType cellType) {
        this.cellType = cellType;
    }

    public void setPathLink(String[] pathLink) {
        this.pathLink = pathLink;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeaderCellImpl)) {
            return false;
        }
        HeaderCellImpl other = (HeaderCellImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        if (this.getLeafCount() != other.getLeafCount()) {
            return false;
        }
        if (this.getPosition() != other.getPosition()) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$property = this.getProperty();
        String other$property = other.getProperty();
        if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<HeaderCellImpl> this$cellList = this.getCellList();
        List<HeaderCellImpl> other$cellList = other.getCellList();
        if (this$cellList == null ? other$cellList != null : !((Object)this$cellList).equals(other$cellList)) {
            return false;
        }
        CellDataType this$cellType = this.getCellType();
        CellDataType other$cellType = other.getCellType();
        if (this$cellType == null ? other$cellType != null : !((Object)((Object)this$cellType)).equals((Object)other$cellType)) {
            return false;
        }
        return Arrays.deepEquals(this.getPathLink(), other.getPathLink());
    }

    protected boolean canEqual(Object other) {
        return other instanceof HeaderCellImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevel();
        result = result * 59 + this.getLeafCount();
        result = result * 59 + this.getPosition();
        result = result * 59 + this.getWidth();
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<HeaderCellImpl> $cellList = this.getCellList();
        result = result * 59 + ($cellList == null ? 43 : ((Object)$cellList).hashCode());
        CellDataType $cellType = this.getCellType();
        result = result * 59 + ($cellType == null ? 43 : ((Object)((Object)$cellType)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPathLink());
        return result;
    }

    public String toString() {
        return "HeaderCellImpl(level=" + this.getLevel() + ", path=" + this.getPath() + ", property=" + this.getProperty() + ", name=" + this.getName() + ", cellList=" + this.getCellList() + ", leafCount=" + this.getLeafCount() + ", position=" + this.getPosition() + ", width=" + this.getWidth() + ", cellType=" + (Object)((Object)this.getCellType()) + ", pathLink=" + Arrays.deepToString(this.getPathLink()) + ")";
    }
}

