package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.util.List;
import java.util.Map;

public interface OutStore {

    SegmentWriter createSegment(String name);

    SegmentWriter createSegment(String name,int rowSize);

    SegmentWriter createSegment(String name,String group);

    SegmentWriter createSegment(String name,int rowSize,String group);

    void commit();

    void close();

    Segment segment(Segment.SD sd);

    List<Segment.SD> sdList();

    CellFile file(byte[] data,String name,String type);

    interface SegmentWriter{

        void append(Map<String,Object> data);

        void append(List<Map<String,Object>> data);

        void append(Model model);

        void meta(Map<String,Object> meta);

        void commit();

        Segment.Title title();

        Segment.Header header();

        String group();
    }

    void fileName(String fileName);

    GroupOperation group(String group);

    Stat stat();

    interface GroupOperation{

        void fileName(String fileName);


    }

    @Data
    class Group implements Model{

        private String fileName;

    }

    @Data
    class Stat implements Model{

        private List<SegmentStat> segmentStatList;

    }

    @Data
    class SegmentStat implements Model{

        private int rowCount;



    }



}
