package com.ovopark.iohub.sdk.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
public class RenderTaskModel implements Model {


    private String uid;

    private boolean nfs;

    private String clientNode;

    private long taskId;

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private LocalDateTime start;

    private Integer exportTaskId;

    private List<RenderSegment> renderSegmentList;

    private boolean dataCollected;

    private String jobFileTempPath;

    private JobMeta jobMeta;

    /**
     * render start...
     */

    private long renderStartTime;

    private String renderStartTimeStr;

}
