package com.ovopark.iohub.sdk.model.proto;

import lombok.Data;

import java.util.List;
import java.util.Map;

import static com.ovopark.kernel.shared.Util.isEmpty;

@Data
public class HeaderCellImpl implements Segment.Header.Cell {

    /**
     * horizontal , H ~ 0 ,1, 2 ,3 ,4 ,5, ...
     */
    private int level;

    private String path;

    private String property;

    private String name;

    private List<HeaderCellImpl> cellList;

    private int leafCount;

    /**
     * vertical , V ~ 0, 1 ,2 ,3, 4, 5, ...
     */
    private int position;

    private int width;

    private CellDataType cellType;

    private String[] pathLink;

    private String i18Key;

    @Override
    public String[] pathLink() {
        if (pathLink==null) {
            pathLink=path.split("\\.");
        }
        return pathLink;
    }

    @Override
    public int width() {
        return width;
    }

    @Override
    public int position() {
        return position;
    }

    @Override
    public CellDataType cellType() {
        return cellType;
    }

    public int calLeafCount() {
        if (isEmpty(cellList)) {
            leafCount = 1;
            return 1;
        }
        int sum = 0;
        for (HeaderCellImpl cell : cellList) {
            int i = cell.calLeafCount();
            sum += i;
        }
        leafCount = sum;
        return sum;
    }

    void calPosition(int position){
        setPosition(position);
        if (isEmpty(cellList)) {
            return;
        }
        for (int i = 0; i < cellList.size(); i++) {
            HeaderCellImpl cell = cellList.get(i);
            if (i==0) {
                cell.calPosition(position);
            }
            else {
                HeaderCellImpl b = cellList.get(i - 1);
                cell.calPosition(b.getPosition()+b.leafCount());
            }
        }

    }

    @Override
    public int level() {
        return getLevel();
    }

    @Override
    public String path() {
        return getPath();
    }

    @Override
    public String property() {
        return getProperty();
    }

    @Override
    public String name() {
        return getName();
    }

    @Override
    public List<? extends Segment.Header.Cell> cellList() {
        return getCellList();
    }

    @Override
    public int leafCount() {
        return getLeafCount();
    }
}
