package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;

import java.util.List;
import java.util.Map;
import java.util.function.Function;

final public class RowValue {


    public static Object getValue(Map<String,Object> map, String path){
        return getValue(map,path.split("\\."));
    }

    public static Object getValue(Map<String,Object> map, String[] pathLink){
        Object object = getValue0(map, pathLink);
        if (object==null) {
            return object;
        }
        if (object instanceof List<?> || object.getClass().isArray()) {
            throw new IllegalStateException(String.join(".",pathLink)+" , data struct error: "+JSONAccessor.impl().format(map));
        }
        return object;
    }

    private static Object getValue0(Map<String,Object> map, String[] pathLink){
        Map<String,Object> mid=map;
        for (int i = 0; i < pathLink.length; i++) {
            String p = pathLink[i];
            Object object = mid.get(p);
            if (object==null) {
                return null;
            }
            if (i < pathLink.length-1 && !(object instanceof Map<?,?>)) {
                throw new IllegalStateException(String.join(".",pathLink)+" , data struct error: "+ JSONAccessor.impl().format(map));
            }
            if(i==pathLink.length-1){
                return object;
            }
            mid= (Map<String, Object>) object;
        }
        return null;
    }

    public static Map<String,Object> map(Model model){
        return JSONAccessor.impl().read(JSONAccessor.impl().format(model));
    }

    public static boolean replace(Map<String,Object> map, String path, Function<Object,CellValue> func){
        return replace(map,path.split("\\."),func);
    }

    public static boolean replace(Map<String,Object> map, String[] pathLink, Function<Object,CellValue> func){
        Map<String,Object> mid=map;
        for (int i = 0; i < pathLink.length; i++) {
            String p = pathLink[i];
            Object object = mid.get(p);
            if (i < pathLink.length-1 && (!(object instanceof Map<?,?>))) {
                return false;
            }
            if(i==pathLink.length-1){
                //replace
                CellValue cellValue = func.apply(object);
                mid.put(p,cellValue);
                return true;
            }
            mid= (Map<String, Object>) object;
        }
        return false;
    }


}
