/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.iohub.sdk.model.proto.RowTransLog;
import com.ovopark.iohub.sdk.model.proto.RowTransLogConfig;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.DBOpeException;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.sequencefile.MixedTransLogImpl;
import com.ovopark.kernel.shared.sequencefile.TransLog;
import com.ovopark.kernel.shared.sequencefile.TransLogConfig;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class MixedRowTransLogImpl
implements RowTransLog {
    private final TransLog transLog;
    private Segment.RowRegion rowRegion;
    private final RowTransLogConfig rowTransLogConfig;
    final String filePath;

    public MixedRowTransLogImpl(String tag, String filePath, RowTransLogConfig rowTransLogConfig) {
        TransLogConfig transLogConfig = new TransLogConfig();
        transLogConfig.setWalBufferSizeMb(rowTransLogConfig.getWalBufferSizeMb());
        transLogConfig.setWalDiskSizeMb(rowTransLogConfig.getWalDiskSizeMb());
        transLogConfig.setWalIntervalSec(rowTransLogConfig.getWalIntervalSec());
        this.transLog = new MixedTransLogImpl(tag, filePath, transLogConfig);
        this.rowRegion = new Segment.RowRegion();
        this.rowTransLogConfig = rowTransLogConfig;
        this.filePath = filePath;
    }

    @Override
    public synchronized void append(Map<String, Object> data) {
        this.rowRegion.getDataList().add(data);
        this.fsyncRegion(false);
    }

    private void fsyncRegion(boolean force) {
        List<Map<String, Object>> dataList = this.rowRegion.getDataList();
        if (dataList.size() > this.rowTransLogConfig.getRegionRowCount() || force) {
            this.transLog.append(Util.utf8((String)JSONAccessor.impl().format((Object)this.rowRegion)));
            if (this.transLog.freeSize() < 0) {
                throw new IllegalStateException("error, exceed max file size: " + this.rowTransLogConfig.getWalDiskSizeMb() + " MB, file: " + this.filePath);
            }
            this.rowRegion = new Segment.RowRegion();
        }
    }

    @Override
    public synchronized void append(List<Map<String, Object>> data) {
        this.rowRegion.getDataList().addAll(data);
        this.fsyncRegion(false);
    }

    @Override
    public synchronized void fsync() throws DBOpeException {
        this.fsyncRegion(true);
        this.transLog.fsync();
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.fsync();
        }
        finally {
            this.transLog.close();
        }
    }
}

