package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public interface OutStore {

    SegmentWriter createSegment(String name);

    SegmentWriter createSegment(String name,int rowSize);

    SegmentWriter createSegment(String name,String group);

    SegmentWriter createSegment(String name,int rowSize,String group);

    void commit();

    void close();

    Segment segment(Segment.SD sd);

    List<Segment.SD> sdList();

    CellFile file(byte[] data,String name,String type);

    interface SegmentWriter{

        void append(Map<String,Object> data);

        void append(List<Map<String,Object>> data);

        void append(Model model);

        void meta(Map<String,Object> meta);

        void commit();

        Segment.Title title();

        Segment.Header header();

        String group();
    }

    void fileName(String fileName);

    GroupOperation group(String group);

    Stat stat();

    RuntimeStat runtimeStat();

    FeatureOperation feature();

    interface GroupOperation{

        void fileName(String fileName);


    }

    interface FeatureOperation {

        void supportRangeMerge(boolean rangeMerge);

        void supportBorder(boolean border);

    }

    @Data
    class Group implements Model{

        private String fileName;

    }

    @Data
    class Feature implements Model{

        private boolean rangeMerge;

        private boolean border;

    }

    @Data
    class Stat implements Model{

        private List<SegmentStat> segmentStatList;

    }

    @Data
    class SegmentStat implements Model{

        private int rowCount;



    }


    interface RuntimeStat{

        void rowCountAdd(int added);

        int rowCount();

        void segmentAdd(String segment);

        String currentSegment();

        int segmentCount();

        void segmentCountAdd(int added);

        long lastIoTimeMs();

        void lastIoTimeMs(long lastIoTimeMs);

    }

    class RuntimeStatImpl implements RuntimeStat{

        final private AtomicInteger rowCount=new AtomicInteger(0);

        final private AtomicInteger segmentCount=new AtomicInteger(0);

        String segment;

        volatile long lastIoTime;

        @Override
        public void rowCountAdd(int added) {
            rowCount.addAndGet(added);
        }

        @Override
        public int rowCount() {
            return rowCount.get();
        }

        @Override
        public void segmentAdd(String segment) {
            this.segment=segment;
        }

        @Override
        public String currentSegment() {
            return segment;
        }

        @Override
        public int segmentCount() {
            return segmentCount.get();
        }

        @Override
        public void segmentCountAdd(int added) {
            segmentCount.addAndGet(added);
        }

        @Override
        public long lastIoTimeMs() {
            return lastIoTime;
        }

        @Override
        public void lastIoTimeMs(long lastIoTimeMs) {
            this.lastIoTime= lastIoTimeMs;
        }
    }


}
