package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.util.Map;

@Data
public class NFSSegmentModel implements Model , SegmentRuntimeStat {

    private String name;

    private String url;

    private Map<String,Object> meta;

    private TitleImpl title;

    private HeaderImpl header;

    /**
     * same group , i.e. in same excel file , xlsx
     *   group1        group2         group3
     *   /    \         /    \          /   \
     * sheet  sheet    ...           ...
     *
     */
    private String group;

    private int rowCount;

    private Segment.Feature feature;

    private SegmentRuntimeStatImpl segmentRuntimeStat;


    @Override
    public void completedRenderRowCount(int completedRenderRowCount) {
        segmentRuntimeStat.setCompletedRenderRowCount(completedRenderRowCount);
    }

    @Override
    public int completedRenderRowCount() {
        return segmentRuntimeStat.getCompletedRenderRowCount();
    }

    @Override
    public void startMs(long startMs) {
        segmentRuntimeStat.setStartMs(startMs);
    }

    @Override
    public long startMs() {
        return segmentRuntimeStat.getStartMs();
    }

    @Override
    public void endMs(long endMs) {
        segmentRuntimeStat.setEndMs(endMs);
    }

    @Override
    public long endMs() {
        return segmentRuntimeStat.getEndMs();
    }
}
