package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.util.Map;

@Data
public class CellValue implements Model {

    private Object showValue;

    private Object value;

    private boolean file;

    final private int cv_flag=1;

    public static CellValue from(Object showValue,Object value){
        CellValue cellValue=new CellValue();
        cellValue.setShowValue(showValue);
        cellValue.setValue(value);
        return cellValue;
    }

    public static CellValue from(CellFile value){
        CellValue cellValue=new CellValue();
        cellValue.setShowValue(null);
        cellValue.setValue(value);
        cellValue.setFile(true);
        return cellValue;
    }

    /**
     *
     * @param valueOrMap  {@link com.ovopark.iohub.sdk.model.proto.CellValue}
     * @return
     */
    public static Object getShowValueFromCellValue(Object valueOrMap){
        if (valueOrMap instanceof Map<?,?>) {
            //is cell value
            return ((Map<?, ?>) valueOrMap).get("showValue");
        }
        return valueOrMap;
    }


    /**
     *
     * @param valueOrMap  {@link com.ovopark.iohub.sdk.model.proto.CellValue}
     * @return
     */
    public static Object getValueFromCellValue(Object valueOrMap){
        if (valueOrMap instanceof Map<?,?>) {
            //is cell value
            return getValueFromMap((Map<?, ?>) valueOrMap);
        }
        return valueOrMap;
    }

    /**
     *
     * @param map
     * @return
     */
    public static Object getValueFromMap(Map<?, ?> map){
        return map.get("value");
    }

    public static CellFile getCellFileFromCellValue(Object valueOrMap){
        Object v = getValueFromCellValue(valueOrMap);
        return v==null?null: JSONAccessor.impl().read(JSONAccessor.impl().format(v), CellFile.class);
    }

    public static boolean testCellValue(Map<?, ?> map){
        return map.containsKey("cv_flag");
    }

    public static boolean testCellValue(Object object){
        return object!=null && Map.class.isAssignableFrom(object.getClass()) && testCellValue((Map<?,?>)object);
    }
}
