/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.sequencefile.SequenceFile;
import com.ovopark.kernel.shared.sequencefile.SequenceFileImpl;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class SegmentFileReader
implements Closeable {
    private final SequenceFile sequenceFile;

    public SegmentFileReader(String path) {
        this(path, 0x40000000L);
    }

    public SegmentFileReader(String path, long size) {
        this.sequenceFile = new SequenceFileImpl("segment", path, size);
    }

    public final synchronized void scan(final RowDataListener rowDataListener) throws IOException {
        this.sequenceFile.scan(new SequenceFile.SequenceRowListener(){

            public void onRow(byte[] bytes, int i, int i1) {
                String c = new String(bytes, i, i1, StandardCharsets.UTF_8);
                Segment.RowRegion rowRegion = (Segment.RowRegion)JSONAccessor.impl().read(c, Segment.RowRegion.class);
                for (Map<String, Object> row : rowRegion.getDataList()) {
                    rowDataListener.onRow(row);
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.sequenceFile.close();
    }

    public static interface RowDataListener {
        public void onRow(Map<String, Object> var1);
    }
}

