package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface Segment extends SegmentRuntimeStatGetter{

    List<Map<String,Object>> rowList();

    int size();

    void append(Map<String,Object> row);

    String name();

    Map<String,Object> meta();

    Title title();

    Header header();

    String group();

    void commit();

    Feature feature();

    @Data
    class SD{

        private String group;

        private String name;

        private boolean memory;

        private String url;

        private Map<String,Object> meta;

        private int rowCount;

    }

    interface Header{

        void maxPossibleHeadIndex(int maxPossibleHeadIndex);

        int maxPossibleHeadIndex();

        int maxHeadIndex();

        HeaderFeatureOperation root(String property);

        void root(List<String> propertyList);

        void children(String path,List<String> propertyList);

        HeaderFeatureOperation children(String path,String property);

        HeaderFeatureOperation children(String path,String property,Width width);

        HeaderFeatureOperation children(String path,String property,Width width,I18n i18n);

        HeaderFeatureOperation children(String path,String property,Width width,I18n i18n,CellType cellType);

        void all(Class<? extends Model> clazz);

        void all(Class<? extends Model> clazz, I18n i18n);

        HeaderFeatureOperation upset(String path,String property,Width width);

        HeaderFeatureOperation upset(String path,String property,Width width,I18n i18n);

        HeaderFeatureOperation upset(String path,String property,Width width,I18n i18n,CellType cellType);

        void upsetAsVirtual(String path,String property);

        void updateAsVirtual(String path);

        void defaultColumnWidth(int width);

        int defaultColumnWidth();

        int height();

        int heightExcludeVirtual();

        void commit();

        void fixed();

        void i18n(Header.I18n i18n);

        void width(Header.Width width);

        Cell cell(String path);

        void printPretty(OutputStream outputStream);

        void printPretty();

        interface I18n{

            String i18n(String path);

        }

        interface Width{
            int width(String path);
        }

        interface CellType{
            CellDataType cellType(String path);
        }

        void scanUp2Down(Scan scan);

        interface Scan{

            void scan(Cell cell);

        }

        interface Cell{

            int level();

            String path();

            String[] pathLink();

            String property();

            String name();

            List<? extends Cell> cellList();

            int leafCount();

            int position();

            int width();

            int excelX();
            
            int excelY();

            CellDataType cellType();

            boolean virtual();

            Segment.HeaderFeature feature();
        }

    }

    interface Title{

        void title(String title);

        String title();

    }

    @Data
    class RowRegion{

        private List<Map<String,Object>> dataList=new ArrayList<>();

    }

    @Data
    class Feature implements Model{

        private boolean rangeMerge;

        private boolean border;

    }

    @Data
    class HeaderFeature implements Model{

        private boolean fontFeatureEnabled;

        private boolean bold;

        private boolean underline;

        private boolean italic;

        private boolean strikeout;

        private String color;

        private boolean hyperlinkFeatureEnabled;

        private boolean hyperlinkUrl;

    }

    interface HeaderFeatureOperation {

        HeaderFeatureOperation fontBold(boolean bold);

        HeaderFeatureOperation fontUnderline(boolean underline);

        HeaderFeatureOperation fontItalic(boolean italic);

        HeaderFeatureOperation fontStrikeout(boolean strikeout);

        HeaderFeatureOperation fontColor(String color);

        /**
         *
         * @param type url
         * @return
         */
        HeaderFeatureOperation hyperlink(String type);

    }

    @Override
    default SegmentRuntimeStat segmentRuntimeStat(){return null;}
}
