package com.ovopark.iohub.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ovopark.kernel.shared.Model;
import lombok.Data;

@Data
public class TaskModel implements Model {

    private String uri;

    private long jobTaskId;

    private Integer exportTaskId;

    private Integer importTaskId;

    private boolean export;

    private Integer userId;

    private String userName;

    private Integer userGroupId;

    private String session;

    private String workNode;

    private String workApp;

    private String clientNode;

    private String clientApp;

    private long acceptTime;

    private String acceptTimeStr;

    private String ioThreadName;

    @JsonIgnore
    transient TransientFunc transientFunc;

    private ExportClientStat exportClientStat;

    private ExportWorkStat exportWorkStat;

    private ImportClientStat importClientStat;

    private ImportWorkStat importWorkStat;

    @Data
    public static class ExportClientStat implements Model{

        private int segmentCount;

        private String currentSegment;

        private int sumRowCount;

        private int rowCountAdded;

        private String lastIoTimeStr;

        private long byteSize;

    }

    @Data
    public static class ExportWorkStat implements Model{


        private String renderFuture;

    }


    @Data
    public static class ImportClientStat implements Model{

        private int maxRowCount;

        private int segmentCount;

        private String currentSegment;

        private int sumRowCount;

        private int rowCountAdded;

        private boolean resetStream;

    }


    @Data
    public static class ImportWorkStat implements Model{

        private int sumRowCount;

        private int segmentCount;

        private String currentSegment;

        private boolean readCompleted;

    }

}
