package com.ovopark.iohub.sdk.model;

import com.ovopark.kernel.shared.Model;
import lombok.Data;

@Data
public class JobMeta implements Model {

    private String name;

    private boolean nfs;

    private int segmentCount;

    private int moduleType;

    private int taskType;

    private String fileName;

    private String uri;

    /**
     * client app, getting data , client node
     */
    private String clientApp;

    /**
     * render node , reading or writing excel
     */
    private String workApp;

    /**
     * export
     */
    private String customRenderBeanClass;

    private boolean sxssf;

    private boolean xls;

    /**
     * export
     */
    private String excelRowListenerBeanClass;

    /**
     * export
     */
    private String excelHeaderListenerBeanClass;

    /**
     * import
     */
    private String customExcelReadBeanClass;

    /**
     * import
     */
    private int skipColumnCount;

    /**
     * import
     */
    private String onlyForTestFile;

    /**
     * import
     */
    private String sheetIndexList;

    /**
     * import , start 0
     */
    private int headerFromIndex;

    /**
     * import , start 0
     */
    private int headerToIndex;

    /**
     * import m [6,9,7,...]
     */
    private String headerMaxColumnIndexList;

    /**
     * import, start 0
     */
    private int dataStartRowIndex;

    /**
     * export
     * @since 1.29
     */
    private int regionRowCount;

    /**
     * export
     * @since 2.7
     */
    private int waitRenderTimeMinute;

    /**
     * export
     * @since 2.10
     */
    private int rowAccessWindowSize;

    /**
     * import
     * @since 2.20
     */
    private boolean validateHeader;
}
