package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.kernel.shared.DBOpeException;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.sequencefile.MixedTransLogImpl;
import com.ovopark.kernel.shared.sequencefile.TransLog;
import com.ovopark.kernel.shared.sequencefile.TransLogConfig;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import static com.ovopark.kernel.shared.Util.utf8;

@Slf4j
public class MixedRowTransLogImpl implements RowTransLog {

    final private TransLog transLog;

    private Segment.RowRegion rowRegion;

    private final RowTransLogConfig rowTransLogConfig;

    final String filePath;

    private long byteSize;

    public MixedRowTransLogImpl(String tag, String filePath, RowTransLogConfig rowTransLogConfig) {

        TransLogConfig transLogConfig=new TransLogConfig();
        transLogConfig.setWalBufferSizeMb(rowTransLogConfig.getWalBufferSizeMb());
        transLogConfig.setWalDiskSizeMb(rowTransLogConfig.getWalDiskSizeMb());
        transLogConfig.setWalIntervalSec(rowTransLogConfig.getWalIntervalSec());
        transLog=new MixedTransLogImpl(tag,filePath, transLogConfig);
        rowRegion=new Segment.RowRegion();
        this.rowTransLogConfig=rowTransLogConfig;
        this.filePath=filePath;
    }


    @Override
    public synchronized void append(Map<String, Object> data) {
        rowRegion.getDataList().add(data);
        fsyncRegion(false);
    }

    private void fsyncRegion(boolean force){
        List<Map<String, Object>> dataList = rowRegion.getDataList();
        if (dataList.size()>rowTransLogConfig.getRegionRowCount() || force) {
            //commit
            try {
                long append = transLog.append(utf8(JSONAccessor.impl().format(rowRegion)));
                byteSize+=append;
            } catch (Exception e) {
                log.error(rowRegion.getDataList().size()+" / " +rowTransLogConfig.getRegionRowCount()
                                +" rows, size exceed "+rowTransLogConfig.getWalBufferSizeMb()+"MB???? ");
                throw DBOpeException.from(e);
            }
            if (transLog.freeSize()<0) {
                throw new IllegalStateException("error, exceed max file size: "+rowTransLogConfig.getWalDiskSizeMb()+" MB, file: "+filePath);
            }
            rowRegion=new Segment.RowRegion();
        }
    }

    @Override
    public synchronized void append(List<Map<String, Object>> data) {
        rowRegion.getDataList().addAll(data);
        fsyncRegion(false);
    }

    @Override
    public synchronized void fsync() throws DBOpeException {
        //fsync region
        fsyncRegion(true);
        transLog.fsync();
    }


    @Override
    public synchronized void close() throws IOException {
        try {
            fsync();
        }
        finally {
            transLog.close();
        }
    }

    @Override
    public long byteSize() {
        return byteSize;
    }
}
